/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileDefaultSorter;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileComponent<T>
extends DefaultComponent {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public GenericFileComponent() {
    }

    public GenericFileComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<T> createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GenericFileEndpoint<T> endpoint = this.buildFileEndpoint(uri, remaining, parameters);
        String sortBy = (String)this.getAndRemoveParameter(parameters, "sortBy", String.class);
        if (ObjectHelper.isNotEmpty((Object)sortBy) && !EndpointHelper.isReferenceParameter((String)sortBy)) {
            String[] groups = sortBy.split(";");
            Iterator it = CastUtils.cast((Iterator)org.apache.camel.support.ObjectHelper.createIterator((Object)groups));
            Comparator<Exchange> comparator = this.createSortByComparator(it);
            endpoint.setSortBy(comparator);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        this.afterPropertiesSet(endpoint);
        return endpoint;
    }

    protected abstract GenericFileEndpoint<T> buildFileEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected abstract void afterPropertiesSet(GenericFileEndpoint<T> var1) throws Exception;

    private Comparator<Exchange> createSortByComparator(Iterator<String> it) {
        if (!it.hasNext()) {
            return null;
        }
        String group = it.next();
        boolean reverse = group.startsWith("reverse:");
        String reminder = reverse ? this.ifStartsWithReturnRemainder("reverse:", group) : group;
        boolean ignoreCase = reminder.startsWith("ignoreCase:");
        reminder = ignoreCase ? this.ifStartsWithReturnRemainder("ignoreCase:", reminder) : reminder;
        StringHelper.notEmpty((String)reminder, (String)"sortBy expression", (Object)((Object)this));
        return GenericFileDefaultSorter.sortByFileLanguage(this.getCamelContext(), reminder, reverse, ignoreCase, this.createSortByComparator(it));
    }
}

