/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import java.net.URI;
import java.util.regex.Pattern;

public abstract class AtlassianHttpClientDecorator
implements DisposableHttpClient {
    private final HttpClient httpClient;
    private final AuthenticationHandler authenticationHandler;

    public AtlassianHttpClientDecorator(HttpClient httpClient, AuthenticationHandler authenticationHandler) {
        this.httpClient = httpClient;
        this.authenticationHandler = authenticationHandler;
    }

    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpClient.flushCacheByUriPattern(urlPattern);
    }

    public Request.Builder newRequest() {
        return new AuthenticatedRequestBuilder();
    }

    public Request.Builder newRequest(URI uri) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(uri);
        return builder;
    }

    public Request.Builder newRequest(URI uri, String contentType, String entity) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(uri);
        builder.setContentType(contentType);
        builder.setEntity(entity);
        return builder;
    }

    public Request.Builder newRequest(String uri) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(URI.create(uri));
        return builder;
    }

    public Request.Builder newRequest(String uri, String contentType, String entity) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(URI.create(uri));
        builder.setContentType(contentType);
        builder.setEntity(entity);
        return builder;
    }

    public <A> ResponseTransformation.Builder<A> transformation() {
        return this.httpClient.transformation();
    }

    public ResponsePromise execute(Request request) {
        return this.httpClient.execute(request);
    }

    private class AuthenticatedRequestBuilder
    extends DefaultRequest.DefaultRequestBuilder {
        public AuthenticatedRequestBuilder() {
            super(AtlassianHttpClientDecorator.this.httpClient);
        }

        public ResponsePromise execute(Request.Method method) {
            if (AtlassianHttpClientDecorator.this.authenticationHandler != null) {
                this.setMethod(method);
                AtlassianHttpClientDecorator.this.authenticationHandler.configure((Request.Builder)this);
            }
            return super.execute(method);
        }
    }
}

