/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class RequestTable<T> {
    protected final Map<Integer, Entry<T>> requests = new HashMap<Integer, Entry<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int index, T vote, CompletableFuture<byte[]> future, int majority) {
        Entry<T> entry = new Entry<T>(future);
        RequestTable requestTable = this;
        synchronized (requestTable) {
            this.requests.put(index, entry);
            entry.add(vote, majority);
        }
    }

    public synchronized boolean add(int index, T sender, int majority) {
        Entry<T> entry = this.requests.get(index);
        return entry != null && entry.add(sender, majority);
    }

    public synchronized boolean isCommitted(int index) {
        Entry<T> entry = this.requests.get(index);
        return entry != null && entry.committed;
    }

    public synchronized int size() {
        return this.requests.size();
    }

    public synchronized void notifyAndRemove(int index, byte[] response) {
        Entry<T> entry = this.requests.get(index);
        if (entry != null) {
            if (entry.client_future != null) {
                entry.client_future.complete(response);
            }
            this.requests.remove(index);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Entry<T>> entry : this.requests.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    protected static class Entry<T> {
        protected final CompletableFuture<byte[]> client_future;
        protected final Set<T> votes = new HashSet<T>();
        protected boolean committed;

        public Entry(CompletableFuture<byte[]> client_future) {
            this.client_future = client_future;
        }

        protected boolean add(T vote, int majority) {
            this.votes.add(vote);
            return this.votes.size() >= majority && this.commit();
        }

        protected boolean commit() {
            boolean prev_committed = this.committed;
            this.committed = true;
            return !prev_committed;
        }

        public String toString() {
            return "committed=" + this.committed + ", votes=" + this.votes;
        }
    }
}

