/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.raft.DynamicMembership;
import org.jgroups.protocols.raft.InternalCommand;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Settable;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Redirects requests to current leader")
public class REDIRECT
extends Protocol
implements Settable,
DynamicMembership {
    protected static final short REDIRECT_ID = 522;
    protected static final short REDIRECT_HDR = 4000;
    protected RAFT raft;
    protected volatile Address local_addr;
    protected volatile View view;
    protected final AtomicInteger request_ids = new AtomicInteger(1);
    protected final Map<Integer, CompletableFuture<byte[]>> requests = new HashMap<Integer, CompletableFuture<byte[]>>();

    @Override
    public byte[] set(byte[] buf, int offset, int length) throws Exception {
        CompletableFuture<byte[]> future = this.setAsync(buf, offset, length);
        return future.get();
    }

    @Override
    public byte[] set(byte[] buf, int offset, int length, long timeout, TimeUnit unit) throws Exception {
        CompletableFuture<byte[]> future = this.setAsync(buf, offset, length);
        return future.get(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<byte[]> setAsync(byte[] buf, int offset, int length) {
        Address leader = this.leader("set()");
        if (Objects.equals(this.local_addr, leader)) {
            return this.raft.setAsync(buf, offset, length);
        }
        int req_id = this.request_ids.getAndIncrement();
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        Map<Integer, CompletableFuture<byte[]>> map = this.requests;
        synchronized (map) {
            this.requests.put(req_id, future);
        }
        this.log.trace("%s: redirecting request %d to leader %s", new Object[]{this.local_addr, req_id, leader});
        Message redirect = new Message(leader, buf, offset, length).putHeader(this.id, (Header)new RedirectHeader(RequestType.SET_REQ, req_id, false));
        this.down_prot.down(redirect);
        return future;
    }

    @Override
    public CompletableFuture<byte[]> addServer(String name) throws Exception {
        return this.changeServer(name, true);
    }

    @Override
    public CompletableFuture<byte[]> removeServer(String name) throws Exception {
        return this.changeServer(name, false);
    }

    public void init() throws Exception {
        super.init();
        this.raft = RAFT.findProtocol(RAFT.class, this, true);
        if (this.raft == null) {
            throw new IllegalStateException("RAFT protocol not found");
        }
    }

    public Object down(Event evt) {
        if (evt.getType() == 8) {
            this.local_addr = (Address)evt.getArg();
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.view = (View)evt.getArg();
        }
        return this.up_prot.up(evt);
    }

    public Object up(Message msg) {
        RedirectHeader hdr = (RedirectHeader)msg.getHeader(this.id);
        if (hdr != null) {
            this.handleEvent(msg, hdr);
            return null;
        }
        return this.up_prot.up(msg);
    }

    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            RedirectHeader hdr = (RedirectHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            batch.remove(msg);
            this.handleEvent(msg, hdr);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEvent(Message msg, RedirectHeader hdr) {
        Address sender = msg.src();
        switch (hdr.type) {
            case SET_REQ: {
                this.log.trace("%s: received redirected request %d from %s", new Object[]{this.local_addr, hdr.corr_id, sender});
                ResponseHandler rsp_handler = new ResponseHandler(sender, hdr.corr_id);
                try {
                    this.raft.setAsync(msg.getRawBuffer(), msg.getOffset(), msg.getLength()).whenComplete((BiConsumer)rsp_handler);
                }
                catch (Throwable t) {
                    rsp_handler.apply(t);
                }
                break;
            }
            case ADD_SERVER: 
            case REMOVE_SERVER: {
                ResponseHandler rsp_handler = new ResponseHandler(sender, hdr.corr_id);
                InternalCommand.Type type = hdr.type == RequestType.ADD_SERVER ? InternalCommand.Type.addServer : InternalCommand.Type.removeServer;
                try {
                    this.raft.changeMembers(new String(msg.getRawBuffer(), msg.getOffset(), msg.getLength()), type).whenComplete((BiConsumer)rsp_handler);
                }
                catch (Throwable t) {
                    rsp_handler.apply(t);
                }
                break;
            }
            case RSP: {
                CompletableFuture<byte[]> future = null;
                Map<Integer, CompletableFuture<byte[]>> map = this.requests;
                synchronized (map) {
                    future = this.requests.remove(hdr.corr_id);
                }
                if (future == null) break;
                this.log.trace("%s: received response for redirected request %d from %s", new Object[]{this.local_addr, hdr.corr_id, sender});
                if (!hdr.exception) {
                    future.complete(msg.getBuffer());
                    break;
                }
                try {
                    Throwable t = (Throwable)Util.objectFromByteBuffer((byte[])msg.getBuffer());
                    future.completeExceptionally(t);
                }
                catch (Exception e) {
                    this.log.error("failed deserializing exception", (Throwable)e);
                }
                break;
            }
            default: {
                this.log.error("type %d not known", new Object[]{hdr.type});
            }
        }
    }

    protected Address leader(String req_type) {
        Address leader = this.raft.leader();
        if (leader == null) {
            throw new RuntimeException(String.format("there is currently no leader to forward %s request to", req_type));
        }
        if (this.view != null && !this.view.containsMember(leader)) {
            throw new RuntimeException("leader " + leader + " is not member of view " + this.view);
        }
        return leader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<byte[]> changeServer(String name, boolean add) throws Exception {
        Address leader = this.leader("addServer()/removeServer()");
        if (Objects.equals(this.local_addr, leader)) {
            return this.raft.changeMembers(name, add ? InternalCommand.Type.addServer : InternalCommand.Type.removeServer);
        }
        int req_id = this.request_ids.getAndIncrement();
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        Map<Integer, CompletableFuture<byte[]>> map = this.requests;
        synchronized (map) {
            this.requests.put(req_id, future);
        }
        this.log.trace("%s: redirecting request %d to leader %s", new Object[]{this.local_addr, req_id, leader});
        byte[] buffer = Util.stringToBytes((String)name);
        Message redirect = new Message(leader, buffer).putHeader(this.id, (Header)new RedirectHeader(add ? RequestType.ADD_SERVER : RequestType.REMOVE_SERVER, req_id, false));
        this.down_prot.down(redirect);
        return future;
    }

    static {
        ClassConfigurator.addProtocol((short)522, REDIRECT.class);
        ClassConfigurator.add((short)4000, RedirectHeader.class);
    }

    public static class RedirectHeader
    extends Header {
        protected RequestType type;
        protected int corr_id;
        protected boolean exception;

        public RedirectHeader() {
        }

        public RedirectHeader(RequestType type, int corr_id, boolean exception) {
            this.type = type;
            this.corr_id = corr_id;
            this.exception = exception;
        }

        public short getMagicId() {
            return 4000;
        }

        public Supplier<? extends Header> create() {
            return RedirectHeader::new;
        }

        public int serializedSize() {
            return 2 + Bits.size((int)this.corr_id);
        }

        public void writeTo(DataOutput out) throws IOException {
            out.writeByte((byte)this.type.ordinal());
            Bits.writeInt((int)this.corr_id, (DataOutput)out);
            out.writeBoolean(this.exception);
        }

        public void readFrom(DataInput in) throws IOException {
            this.type = RequestType.values()[in.readByte()];
            this.corr_id = Bits.readInt((DataInput)in);
            this.exception = in.readBoolean();
        }

        public String toString() {
            return this.type.toString() + ", corr_id=" + this.corr_id + ", exception=" + this.exception;
        }
    }

    protected class ResponseHandler
    implements BiConsumer<byte[], Throwable> {
        protected final Address dest;
        protected final int corr_id;

        public ResponseHandler(Address dest, int corr_id) {
            this.dest = dest;
            this.corr_id = corr_id;
        }

        @Override
        public void accept(byte[] buf, Throwable ex) {
            if (ex != null) {
                this.apply(ex);
            } else {
                this.apply(buf);
            }
        }

        protected void apply(byte[] arg) {
            Message msg = new Message(this.dest, arg).putHeader(REDIRECT.this.id, (Header)new RedirectHeader(RequestType.RSP, this.corr_id, false));
            REDIRECT.this.down_prot.down(msg);
        }

        protected void apply(Throwable t) {
            try {
                byte[] buf = Util.objectToByteBuffer((Object)t);
                Message msg = new Message(this.dest, buf).putHeader(REDIRECT.this.id, (Header)new RedirectHeader(RequestType.RSP, this.corr_id, true));
                REDIRECT.this.down_prot.down(msg);
            }
            catch (Exception ex) {
                REDIRECT.this.log.error("failed serializing exception", (Throwable)ex);
            }
        }
    }

    public static enum RequestType {
        SET_REQ,
        ADD_SERVER,
        REMOVE_SERVER,
        RSP;

    }
}

