/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.raft.DynamicMembership;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Settable;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.Util;

@MBean(description="Listens on a socket for client requests, forwards them to the leader and send responses")
public class CLIENT
extends Protocol
implements Runnable {
    protected static final short CLIENT_ID = 523;
    protected static final byte[] BUF = new byte[0];
    @Property(description="Port to listen for client requests", writable=false)
    protected int port = 1965;
    @Property(name="bind_addr", description="The bind address which should be used by the server socket. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL, NON_LOOPBACK, match-interface, match-host, match-address", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @Property(description="The min threads in the thread pool")
    protected int min_threads = 2;
    @Property(description="Max number of threads in the thread pool")
    protected int max_threads = 100;
    @Property(description="Number of ms a thread can be idle before being removed from the thread pool")
    protected long idle_time = 5000L;
    protected Settable settable;
    protected DynamicMembership dyn_membership;
    protected ServerSocket sock;
    protected ExecutorService thread_pool;
    protected Thread acceptor;

    public void init() throws Exception {
        super.init();
        this.settable = RAFT.findProtocol(Settable.class, this, true);
        if (this.settable == null) {
            throw new IllegalStateException("did not find a protocol implementing Settable (e.g. REDIRECT or RAFT)");
        }
        this.dyn_membership = RAFT.findProtocol(DynamicMembership.class, this, true);
        if (this.dyn_membership == null) {
            throw new IllegalStateException("did not find a protocol implementing DynamicMembership (e.g. REDIRECT or RAFT)");
        }
    }

    public void start() throws Exception {
        super.start();
        this.sock = Util.createServerSocket((SocketFactory)this.getSocketFactory(), (String)"CLIENR.srv_sock", (InetAddress)this.bind_addr, (int)this.port, (int)(this.port + 50));
        this.thread_pool = new ThreadPoolExecutor(this.min_threads, this.max_threads, this.idle_time, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)this.getThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
        this.acceptor = new Thread((Runnable)this, "CLIENT.Acceptor");
        this.acceptor.start();
    }

    public void stop() {
        super.stop();
        Util.close((Closeable)this.sock);
        this.thread_pool.shutdown();
    }

    public void destroy() {
        super.destroy();
        Util.close((Closeable)this.sock);
        if (this.thread_pool != null) {
            this.thread_pool.shutdown();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket client_sock = this.sock.accept();
                    this.thread_pool.execute(new RequestHandler(client_sock));
                }
            }
            catch (IOException e) {
                if (!this.sock.isClosed()) continue;
                return;
            }
            catch (Throwable ex) {
                this.log.error("error accepting new connection", ex);
                continue;
            }
            break;
        }
    }

    static {
        ClassConfigurator.addProtocol((short)523, CLIENT.class);
    }

    protected class RequestHandler
    implements Runnable {
        protected final Socket client_sock;

        public RequestHandler(Socket client_sock) {
            this.client_sock = client_sock;
        }

        @Override
        public void run() {
            DataInputStream in = null;
            DataOutputStream out = null;
            CompletionHandler completion_handler = null;
            try {
                in = new DataInputStream(this.client_sock.getInputStream());
                out = new DataOutputStream(this.client_sock.getOutputStream());
                completion_handler = new CompletionHandler(this.client_sock, in, out);
                RequestType type = RequestType.values()[in.readByte()];
                int length = in.readInt();
                byte[] buffer = new byte[length];
                in.readFully(buffer);
                switch (type) {
                    case set_req: {
                        CLIENT.this.settable.setAsync(buffer, 0, buffer.length).whenComplete((BiConsumer)new CompletionHandler(this.client_sock, in, out));
                        break;
                    }
                    case add_server: {
                        CLIENT.this.dyn_membership.addServer(Util.bytesToString((byte[])buffer)).whenComplete((BiConsumer)completion_handler);
                        break;
                    }
                    case remove_server: {
                        CLIENT.this.dyn_membership.removeServer(Util.bytesToString((byte[])buffer)).whenComplete((BiConsumer)completion_handler);
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                CLIENT.this.log.error("failed handling request", ex);
                if (completion_handler != null) {
                    completion_handler.accept(null, ex);
                }
                Util.close((Closeable[])new Closeable[]{in, out, this.client_sock});
            }
        }

        protected void send(DataOutput out, RequestType type, byte[] buffer, int offset, int length) throws Exception {
            out.writeByte((byte)type.ordinal());
            int len = buffer == null ? 0 : length;
            out.writeInt(len);
            if (len > 0) {
                out.write(buffer, offset, length);
            }
        }

        protected class CompletionHandler
        implements BiConsumer<byte[], Throwable> {
            protected final Socket s;
            protected final DataInputStream input;
            protected final DataOutputStream output;

            public CompletionHandler(Socket client_sock, DataInputStream input, DataOutputStream output) {
                this.s = client_sock;
                this.input = input;
                this.output = output;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(byte[] buf, Throwable ex) {
                block6: {
                    if (ex == null) break block6;
                    byte[] rsp_buffer = Util.objectToByteBuffer((Object)ex);
                    RequestHandler.this.send(this.output, RequestType.rsp, rsp_buffer, 0, rsp_buffer.length);
                    Util.close((Closeable[])new Closeable[]{this.output, this.input, this.s});
                    return;
                }
                try {
                    if (buf == null) {
                        buf = BUF;
                    }
                    RequestHandler.this.send(this.output, RequestType.rsp, buf, 0, buf.length);
                }
                catch (Throwable t) {
                    try {
                        CLIENT.this.log.error("failed in sending response to client", t);
                    }
                    catch (Throwable throwable) {
                        Util.close((Closeable[])new Closeable[]{this.output, this.input, this.s});
                        throw throwable;
                    }
                    Util.close((Closeable[])new Closeable[]{this.output, this.input, this.s});
                }
                Util.close((Closeable[])new Closeable[]{this.output, this.input, this.s});
            }
        }
    }

    public static enum RequestType {
        set_req,
        add_server,
        remove_server,
        type,
        rsp;

    }
}

