/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Settable;
import org.jgroups.protocols.raft.StateMachine;

public class RaftHandle
implements Settable {
    protected JChannel ch;
    protected RAFT raft;
    protected Settable settable;

    public RaftHandle(JChannel ch, StateMachine sm) {
        this.ch = ch;
        if (this.ch == null) {
            throw new IllegalStateException("channel must not be null");
        }
        this.raft = RAFT.findProtocol(RAFT.class, ch.getProtocolStack().getTopProtocol(), true);
        if (this.raft == null) {
            throw new IllegalStateException("RAFT protocol was not found");
        }
        this.settable = RAFT.findProtocol(Settable.class, ch.getProtocolStack().getTopProtocol(), true);
        if (this.settable == null) {
            throw new IllegalStateException("did not find a protocol implementing Settable (e.g. REDIRECT or RAFT)");
        }
        this.stateMachine(sm);
    }

    public JChannel channel() {
        return this.ch;
    }

    public RAFT raft() {
        return this.raft;
    }

    public String raftId() {
        return this.raft.raftId();
    }

    public RaftHandle raftId(String id) {
        this.raft.raftId(id);
        return this;
    }

    public Address leader() {
        return this.raft.leader();
    }

    public boolean isLeader() {
        return this.raft.isLeader();
    }

    public StateMachine stateMachine() {
        return this.raft.stateMachine();
    }

    public RaftHandle stateMachine(StateMachine sm) {
        this.raft.stateMachine(sm);
        return this;
    }

    public RaftHandle addRoleListener(RAFT.RoleChange listener) {
        this.raft.addRoleListener(listener);
        return this;
    }

    public RaftHandle removeRoleListener(RAFT.RoleChange listener) {
        this.raft.remRoleListener(listener);
        return this;
    }

    public int currentTerm() {
        return this.raft.currentTerm();
    }

    public int lastApplied() {
        return this.raft.lastAppended();
    }

    public int commitIndex() {
        return this.raft.commitIndex();
    }

    public void snapshot() throws Exception {
        this.raft.snapshot();
    }

    public Log log() {
        return this.raft.log();
    }

    public int logSize() {
        return this.raft.logSize();
    }

    public int logSizeInBytes() {
        return this.raft.logSizeInBytes();
    }

    public void logEntries(ObjIntConsumer<LogEntry> func) {
        this.raft.logEntries(func);
    }

    @Override
    public byte[] set(byte[] buf, int offset, int length) throws Exception {
        return this.settable.set(buf, offset, length);
    }

    @Override
    public byte[] set(byte[] buf, int offset, int length, long timeout, TimeUnit unit) throws Exception {
        return this.settable.set(buf, offset, length, timeout, unit);
    }

    @Override
    public CompletableFuture<byte[]> setAsync(byte[] buf, int offset, int length) {
        return this.settable.setAsync(buf, offset, length);
    }
}

