/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import org.jgroups.Address;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.RaftImpl;
import org.jgroups.raft.util.RequestTable;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Util;

public class Leader
extends RaftImpl {
    public Leader(RAFT raft) {
        super(raft);
    }

    @Override
    public void init() {
        super.init();
        this.raft.createRequestTable();
        this.raft.createCommitTable();
        this.raft.startResendTask();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.raft.stopResendTask();
        this.raft.request_table = null;
        this.raft.commit_table = null;
    }

    @Override
    protected void handleAppendEntriesResponse(Address sender, int term, AppendResult result) {
        RequestTable<String> reqtab = this.raft.request_table;
        if (reqtab == null) {
            throw new IllegalStateException("request table cannot be null in leader");
        }
        ExtendedUUID uuid = (ExtendedUUID)sender;
        String sender_raft_id = Util.bytesToString((byte[])uuid.get(RAFT.raft_id_key));
        this.raft.getLog().trace("%s: received AppendEntries response from %s for term %d: %s", new Object[]{this.raft.local_addr, sender, term, result});
        if (result.success) {
            this.raft.commit_table.update(sender, result.getIndex(), result.getIndex() + 1, result.commit_index, false);
            if (reqtab.add(result.index, sender_raft_id, this.raft.majority())) {
                this.raft.handleCommit(result.index);
            }
        } else {
            this.raft.commit_table.update(sender, 0, result.getIndex(), result.commit_index, true);
        }
    }
}

