/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;

public class AppendResult
implements Streamable {
    protected boolean success;
    protected int index;
    protected int commit_index;
    protected int non_matching_term;

    public AppendResult() {
    }

    public AppendResult(boolean success, int index) {
        this.success = success;
        this.index = index;
    }

    public AppendResult(boolean success, int index, int non_matching_term) {
        this.success = success;
        this.index = index;
        this.non_matching_term = non_matching_term;
    }

    public boolean success() {
        return this.success;
    }

    public int index() {
        return this.index;
    }

    public int commitIndex() {
        return this.commit_index;
    }

    public int nonMatchingTerm() {
        return this.non_matching_term;
    }

    public AppendResult commitIndex(int ci) {
        this.commit_index = ci;
        return this;
    }

    public int size() {
        return 1 + Bits.size((int)this.index) + Bits.size((int)this.commit_index) + Bits.size((int)this.non_matching_term);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeBoolean(this.success);
        Bits.writeInt((int)this.index, (DataOutput)out);
        Bits.writeInt((int)this.commit_index, (DataOutput)out);
        Bits.writeInt((int)this.non_matching_term, (DataOutput)out);
    }

    public void readFrom(DataInput in) throws IOException {
        this.success = in.readBoolean();
        this.index = Bits.readInt((DataInput)in);
        this.commit_index = Bits.readInt((DataInput)in);
        this.non_matching_term = Bits.readInt((DataInput)in);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMatchingTerm() {
        return this.non_matching_term;
    }

    public String toString() {
        return this.success + ", index=" + this.index + ", commit-index=" + this.commit_index;
    }
}

