/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class AppendEntriesRequest
extends RaftHeader {
    protected Address leader;
    protected int prev_log_index;
    protected int prev_log_term;
    protected int entry_term;
    protected int leader_commit;
    protected boolean internal;

    public AppendEntriesRequest() {
    }

    public AppendEntriesRequest(int term, Address leader, int prev_log_index, int prev_log_term, int entry_term, int leader_commit, boolean internal) {
        super(term);
        this.leader = leader;
        this.prev_log_index = prev_log_index;
        this.prev_log_term = prev_log_term;
        this.entry_term = entry_term;
        this.leader_commit = leader_commit;
        this.internal = internal;
    }

    public short getMagicId() {
        return 2000;
    }

    public Supplier<? extends Header> create() {
        return AppendEntriesRequest::new;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Util.size((Address)this.leader) + Bits.size((int)this.prev_log_index) + Bits.size((int)this.prev_log_term) + Bits.size((int)this.entry_term) + Bits.size((int)this.leader_commit) + 1;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Util.writeAddress((Address)this.leader, (DataOutput)out);
        Bits.writeInt((int)this.prev_log_index, (DataOutput)out);
        Bits.writeInt((int)this.prev_log_term, (DataOutput)out);
        Bits.writeInt((int)this.entry_term, (DataOutput)out);
        Bits.writeInt((int)this.leader_commit, (DataOutput)out);
        out.writeBoolean(this.internal);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.leader = Util.readAddress((DataInput)in);
        this.prev_log_index = Bits.readInt((DataInput)in);
        this.prev_log_term = Bits.readInt((DataInput)in);
        this.entry_term = Bits.readInt((DataInput)in);
        this.leader_commit = Bits.readInt((DataInput)in);
        this.internal = in.readBoolean();
    }

    @Override
    public String toString() {
        return super.toString() + ", leader=" + this.leader + ", prev_log_index=" + this.prev_log_index + ", prev_log_term=" + this.prev_log_term + ", entry_term=" + this.entry_term + ", leader_commit=" + this.leader_commit + ", internal=" + this.internal;
    }
}

