/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEndpoint;
import org.apache.camel.component.jgroups.raft.utils.NopStateMachine;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultComponent;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.RaftHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="jgroups-raft")
public class JGroupsRaftComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsRaftComponent.class);
    @UriParam
    @Metadata(defaultValue="null")
    private RaftHandle raftHandle;
    @UriParam
    @Metadata(defaultValue="NopStateMachine")
    private StateMachine stateMachine = new NopStateMachine();
    @UriParam
    @Metadata(required=true)
    private String raftId;
    @UriParam
    @Metadata(defaultValue="raft.xml")
    private String channelProperties;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
        return new JGroupsRaftEndpoint(uri, remaining, (Component)this, remaining, parameters, this.raftId, this.channelProperties, this.stateMachine, this.raftHandle);
    }

    public RaftHandle getRaftHandle() {
        return this.raftHandle;
    }

    public void setRaftHandle(RaftHandle raftHandle) {
        this.raftHandle = raftHandle;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public String getRaftId() {
        return this.raftId;
    }

    public void setRaftId(String raftId) {
        this.raftId = raftId;
    }

    public String getChannelProperties() {
        return this.channelProperties;
    }

    public void setChannelProperties(String channelProperties) {
        this.channelProperties = channelProperties;
    }
}

