/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.jcr;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelJcrSourceConnectorConfig extends CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_JCR_PATH_HOST_CONF = "camel.source.path.host";
    public static final String CAMEL_SOURCE_JCR_PATH_HOST_DOC = "Name of the javax.jcr.Repository to lookup from the Camel registry to be used.";
    public static final String CAMEL_SOURCE_JCR_PATH_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_PATH_BASE_CONF = "camel.source.path.base";
    public static final String CAMEL_SOURCE_JCR_PATH_BASE_DOC = "Get the base node when accessing the repository";
    public static final String CAMEL_SOURCE_JCR_PATH_BASE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_DEEP_CONF = "camel.source.endpoint.deep";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_DEEP_DOC = "When isDeep is true, events whose associated parent node is at absPath or within its subgraph are received.";
    public static final Boolean CAMEL_SOURCE_JCR_ENDPOINT_DEEP_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EVENT_TYPES_CONF = "camel.source.endpoint.eventTypes";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EVENT_TYPES_DOC = "eventTypes (a combination of one or more event types encoded as a bit mask value such as javax.jcr.observation.Event.NODE_ADDED, javax.jcr.observation.Event.NODE_REMOVED, etc.).";
    public static final Integer CAMEL_SOURCE_JCR_ENDPOINT_EVENT_TYPES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_NODE_TYPE_NAMES_CONF = "camel.source.endpoint.nodeTypeNames";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_NODE_TYPE_NAMES_DOC = "When a comma separated nodeTypeName list string is set, only events whose associated parent node has one of the node types (or a subtype of one of the node types) in this list will be received.";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_NODE_TYPE_NAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_NO_LOCAL_CONF = "camel.source.endpoint.noLocal";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_NO_LOCAL_DOC = "If noLocal is true, then events generated by the session through which the listener was registered are ignored. Otherwise, they are not ignored.";
    public static final Boolean CAMEL_SOURCE_JCR_ENDPOINT_NO_LOCAL_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_PASSWORD_DOC = "Password for login";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_CONF = "camel.source.endpoint.sessionLiveCheckInterval";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_DOC = "Interval in milliseconds to wait before each session live checking The default value is 60000 ms.";
    public static final Long CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_ON_START_CONF = "camel.source.endpoint.sessionLiveCheckIntervalOnStart";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_ON_START_DOC = "Interval in milliseconds to wait before the first session live checking. The default value is 3000 ms.";
    public static final Long CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_ON_START_DEFAULT = 3000L;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_USERNAME_DOC = "Username for login";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_UUIDS_CONF = "camel.source.endpoint.uuids";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_UUIDS_DOC = "When a comma separated uuid list string is set, only events whose associated parent node has one of the identifiers in the comma separated uuid list will be received.";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_UUIDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_WORKSPACE_NAME_CONF = "camel.source.endpoint.workspaceName";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_WORKSPACE_NAME_DOC = "The workspace to access. If it's not specified then the default one will be used";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_WORKSPACE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JCR_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_JCR_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_JCR_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCR_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.jcr.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JCR_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JCR_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCR_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.jcr.autowiredEnabled";
    public static final String CAMEL_SOURCE_JCR_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_JCR_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelJcrSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelJcrSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_JCR_PATH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_PATH_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JCR_PATH_HOST_DOC);
        conf.define(CAMEL_SOURCE_JCR_PATH_BASE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_PATH_BASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_PATH_BASE_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_DEEP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCR_ENDPOINT_DEEP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_DEEP_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_EVENT_TYPES_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_JCR_ENDPOINT_EVENT_TYPES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_EVENT_TYPES_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_NODE_TYPE_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_NODE_TYPE_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_NODE_TYPE_NAMES_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_NO_LOCAL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCR_ENDPOINT_NO_LOCAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_NO_LOCAL_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_ON_START_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_ON_START_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_SESSION_LIVE_CHECK_INTERVAL_ON_START_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_UUIDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_UUIDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_UUIDS_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_WORKSPACE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_WORKSPACE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_WORKSPACE_NAME_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCR_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCR_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_JCR_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCR_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_JCR_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCR_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JCR_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCR_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCR_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}