/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.core.LowPriorityTask;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class LazyTextExtractorField
extends AbstractField {
    private static final Logger log = LoggerFactory.getLogger(LazyTextExtractorField.class);
    private volatile String extract = null;

    public LazyTextExtractorField(Parser parser, InternalValue value, Metadata metadata, Executor executor, boolean highlighting, int maxFieldLength, boolean withNorms) {
        super(FieldNames.FULLTEXT, highlighting ? Field.Store.YES : Field.Store.NO, withNorms ? Field.Index.ANALYZED : Field.Index.ANALYZED_NO_NORMS, highlighting ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO);
        executor.execute(new ParsingTask(parser, value, metadata, maxFieldLength){

            @Override
            public void setExtractedText(String value) {
                LazyTextExtractorField.this.setExtractedText(value);
            }
        });
    }

    public synchronized String stringValue() {
        try {
            while (!this.isExtractorFinished()) {
                ((Object)((Object)this)).wait();
            }
            return this.extract;
        }
        catch (InterruptedException e) {
            log.error("Text extraction thread was interrupted", (Throwable)e);
            return "";
        }
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        return null;
    }

    public boolean isExtractorFinished() {
        return this.extract != null;
    }

    private synchronized void setExtractedText(String value) {
        this.extract = value;
        ((Object)((Object)this)).notify();
    }

    public void dispose() {
    }

    static abstract class ParsingTask
    extends BodyContentHandler
    implements LowPriorityTask {
        private final Parser parser;
        private final InternalValue value;
        private final Metadata metadata;
        private final WriteOutContentHandler writeOutContentHandler;

        public ParsingTask(Parser parser, InternalValue value, Metadata metadata, int maxFieldLength) {
            this(new WriteOutContentHandler(maxFieldLength), parser, value, metadata);
        }

        private ParsingTask(WriteOutContentHandler writeOutContentHandler, Parser parser, InternalValue value, Metadata metadata) {
            super((ContentHandler)writeOutContentHandler);
            this.writeOutContentHandler = writeOutContentHandler;
            this.parser = parser;
            this.value = value;
            this.metadata = metadata;
        }

        @Override
        public void run() {
            try (InputStream stream = this.value.getStream();){
                this.parser.parse(stream, (ContentHandler)((Object)this), this.metadata, new ParseContext());
            }
            catch (LinkageError e) {
                if (!this.writeOutContentHandler.isWriteLimitReached((Throwable)e)) {
                    log.debug("Failed to extract text from a binary property. This is a fairly common case, and nothing to worry about. The stack trace is included to help improve the text extraction feature.", (Throwable)e);
                    this.setExtractedText("TextExtractionError");
                    return;
                }
            }
            catch (Throwable t) {
                if (!this.writeOutContentHandler.isWriteLimitReached(t)) {
                    log.debug("Failed to extract text from a binary property. This is a fairly common case, and nothing to worry about. The stack trace is included to help improve the text extraction feature.", t);
                    this.setExtractedText("TextExtractionError");
                    return;
                }
            }
            finally {
                this.value.discard();
            }
            this.setExtractedText(this.writeOutContentHandler.toString());
        }

        protected abstract void setExtractedText(String var1);
    }
}

