/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.validator;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorValidator
extends Validator {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorValidator.class);
    private Processor processor;
    private String validatorString;

    public ProcessorValidator(CamelContext context) {
        this.setCamelContext(context);
    }

    public void validate(Message message, DataType type) throws ValidationException {
        Exchange exchange = message.getExchange();
        LOG.debug("Sending to validate processor '{}'", (Object)this.processor);
        DefaultExchange validateExchange = new DefaultExchange(exchange);
        validateExchange.setIn(message);
        ((ExtendedExchange)validateExchange.adapt(ExtendedExchange.class)).setProperties(exchange.getProperties());
        try {
            this.processor.process((Exchange)validateExchange);
            if (validateExchange.getException() != null) {
                exchange.setException((Throwable)validateExchange.getException());
            } else {
                ExchangeHelper.copyResults((Exchange)exchange, (Exchange)validateExchange);
            }
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            throw new ValidationException(String.format("Validation failed for '%s'", type), exchange, (Throwable)e);
        }
    }

    public ProcessorValidator setProcessor(Processor processor) {
        this.processor = processor;
        this.validatorString = null;
        return this;
    }

    public String toString() {
        if (this.validatorString == null) {
            this.validatorString = String.format("ProcessorValidator[type='%s', processor='%s']", this.getType(), this.processor);
        }
        return this.validatorString;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.processor, (String)"processor", (Object)((Object)this));
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }
}

