/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JcrEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host/base";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jcr".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "base", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(18);
        props.add("basicPropertyBinding");
        props.add("deep");
        props.add("sessionLiveCheckInterval");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("eventTypes");
        props.add("noLocal");
        props.add("password");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("host");
        props.add("workspaceName");
        props.add("nodeTypeNames");
        props.add("exceptionHandler");
        props.add("base");
        props.add("sessionLiveCheckIntervalOnStart");
        props.add("username");
        props.add("uuids");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

