/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalBaseline;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersionManagerImplBase;
import org.apache.jackrabbit.core.version.VersionManagerImplMerge;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VersionManagerImplConfig
extends VersionManagerImplMerge {
    private static final Logger log = LoggerFactory.getLogger(VersionManagerImplConfig.class);

    protected VersionManagerImplConfig(SessionContext context, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        super(context, stateMgr, hierMgr);
    }

    protected NodeId restore(NodeStateEx parent, Name name, InternalBaseline baseline) throws RepositoryException {
        NodeId configId = baseline.getConfigurationId();
        NodeId rootId = baseline.getConfigurationRootId();
        if (this.stateMgr.hasItemState(rootId)) {
            NodeStateEx existing = parent.getNode(rootId);
            String msg = "Configuration for the given baseline already exists at: " + this.safeGetJCRPath(existing);
            log.error(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        VersionSet versions = baseline.getBaseVersions();
        InternalVersion rootVersion = null;
        for (InternalVersion v : versions.versions().values()) {
            if (!v.getVersionHistory().getVersionableId().equals(rootId)) continue;
            rootVersion = v;
            break;
        }
        if (rootVersion == null) {
            String msg = "Internal error: supplied baseline has no version for its configuration root.";
            log.error(msg);
            throw new RepositoryException(msg);
        }
        try (VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();){
            if (!this.stateMgr.hasItemState(configId)) {
                this.internalCreateConfiguration(rootId, configId, baseline.getId());
            }
            NodeStateEx config = parent.getNode(configId);
            InternalFrozenNode fn = rootVersion.getFrozenNode();
            NodeStateEx state = parent.addNode(name, fn.getFrozenPrimaryType(), fn.getFrozenId());
            state.setMixins(fn.getFrozenMixinTypes());
            parent.store();
            this.internalRestore(config, baseline, null, false);
            ops.save();
            NodeId nodeId = configId;
            return nodeId;
        }
    }

    protected NodeId createConfiguration(NodeStateEx state) throws RepositoryException {
        try (VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();){
            NodeId configId = this.internalCreateConfiguration(state.getNodeId(), null, null);
            state.setPropertyValue(NameConstants.JCR_CONFIGURATION, InternalValue.create(configId));
            state.store();
            ops.save();
            NodeId nodeId = configId;
            return nodeId;
        }
    }

    private NodeId internalCreateConfiguration(NodeId rootId, NodeId configId, NodeId baseLine) throws RepositoryException {
        NodeStateEx configRoot = this.internalGetConfigRoot();
        NodeStateEx configParent = InternalVersionManagerBase.getParentNode(configRoot, rootId.toString(), NameConstants.REP_CONFIGURATIONS);
        Name name = InternalVersionManagerBase.getName(rootId.toString());
        if (configId == null) {
            configId = this.context.getNodeIdFactory().newNodeId();
        }
        NodeStateEx config = configParent.addNode(name, NameConstants.NT_CONFIGURATION, configId, true);
        HashSet<Name> mix = new HashSet<Name>();
        mix.add(NameConstants.REP_VERSION_REFERENCE);
        config.setMixins(mix);
        config.setPropertyValue(NameConstants.JCR_ROOT, InternalValue.create(rootId));
        VersionHistoryInfo vh = this.vMgr.getVersionHistory((Session)this.session, config.getState(), null);
        InternalValue historyId = InternalValue.create(vh.getVersionHistoryId());
        InternalValue versionId = InternalValue.create(baseLine == null ? vh.getRootVersionId() : baseLine);
        config.setPropertyValue(NameConstants.JCR_BASEVERSION, versionId);
        config.setPropertyValue(NameConstants.JCR_VERSIONHISTORY, historyId);
        config.setPropertyValue(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
        config.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, new InternalValue[]{versionId});
        configParent.store();
        return configId;
    }

    private NodeStateEx internalGetConfigRoot() throws RepositoryException {
        NodeStateEx system = this.getNodeStateEx(RepositoryImpl.SYSTEM_ROOT_NODE_ID);
        NodeStateEx root = system.getNode(NameConstants.JCR_CONFIGURATIONS, 1);
        if (root == null) {
            root = system.addNode(NameConstants.JCR_CONFIGURATIONS, NameConstants.REP_CONFIGURATIONS, RepositoryImpl.CONFIGURATIONS_NODE_ID, false);
            system.store();
        }
        return root;
    }
}

