/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalBaseline;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class InternalBaselineImpl
extends InternalVersionImpl
implements InternalBaseline {
    InternalBaselineImpl(InternalVersionHistoryImpl vh, NodeStateEx node, Name name) throws RepositoryException {
        super(vh, node, name);
    }

    @Override
    public VersionSet getBaseVersions() throws RepositoryException {
        InternalValue[] vs = ((InternalFrozenNodeImpl)this.getFrozenNode()).node.getPropertyValues(NameConstants.REP_VERSIONS);
        HashMap<NodeId, InternalVersion> versions = new HashMap<NodeId, InternalVersion>();
        if (vs != null) {
            for (InternalValue v : vs) {
                InternalVersion iv = this.vMgr.getVersion(v.getNodeId());
                if (iv == null) continue;
                versions.put(iv.getVersionHistory().getId(), iv);
            }
        }
        return new VersionSet(versions);
    }

    @Override
    public NodeId getConfigurationId() {
        return this.getVersionHistory().getVersionableId();
    }

    @Override
    public NodeId getConfigurationRootId() {
        return ((InternalFrozenNodeImpl)this.getFrozenNode()).node.getPropertyValue(NameConstants.JCR_ROOT).getNodeId();
    }
}

