/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;

public class QueryHandlerContext {
    private final String workspace;
    private final RepositoryContext repositoryContext;
    private final SharedItemStateManager stateMgr;
    private final CachingHierarchyManager hmgr;
    private final PersistenceManager pm;
    private NodeId rootId;
    private final PropertyTypeRegistry propRegistry;
    private final QueryHandler parentHandler;
    private final NodeId excludedNodeId;

    public QueryHandlerContext(String workspace, RepositoryContext repositoryContext, SharedItemStateManager stateMgr, PersistenceManager pm, NodeId rootId, QueryHandler parentHandler, NodeId excludedNodeId) {
        this.workspace = workspace;
        this.repositoryContext = repositoryContext;
        this.stateMgr = stateMgr;
        this.hmgr = new CachingHierarchyManager(rootId, stateMgr);
        this.stateMgr.addListener(this.hmgr);
        this.pm = pm;
        this.rootId = rootId;
        NodeTypeRegistry ntRegistry = repositoryContext.getNodeTypeRegistry();
        this.propRegistry = new PropertyTypeRegistry(ntRegistry);
        this.parentHandler = parentHandler;
        this.excludedNodeId = excludedNodeId;
        ntRegistry.addListener(this.propRegistry);
    }

    public ItemStateManager getItemStateManager() {
        return this.stateMgr;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hmgr;
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public NodeId getRootId() {
        return this.rootId;
    }

    public PropertyTypeRegistry getPropertyTypeRegistry() {
        return this.propRegistry;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.repositoryContext.getNodeTypeRegistry();
    }

    public NamespaceRegistryImpl getNamespaceRegistry() {
        return this.repositoryContext.getNamespaceRegistry();
    }

    public QueryHandler getParentHandler() {
        return this.parentHandler;
    }

    public NodeId getExcludedNodeId() {
        return this.excludedNodeId;
    }

    public void destroy() {
        this.repositoryContext.getNodeTypeRegistry().removeListener(this.propRegistry);
    }

    public ScheduledExecutorService getExecutor() {
        return this.repositoryContext.getExecutor();
    }

    public ClusterNode getClusterNode() {
        return this.repositoryContext.getClusterNode();
    }

    public String getWorkspace() {
        return this.workspace;
    }
}

