/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.spi.PrivilegeDefinition;

public class PrivilegeRecord
extends ClusterRecord {
    static final char IDENTIFIER = 'A';
    private Collection<PrivilegeDefinition> definitions;

    protected PrivilegeRecord(Record record) {
        super(record);
    }

    protected PrivilegeRecord(Collection<PrivilegeDefinition> definitions, Record record) {
        super(record);
        this.definitions = definitions;
    }

    @Override
    protected void doRead() throws JournalException {
        int size = this.record.readInt();
        this.definitions = new HashSet<PrivilegeDefinition>();
        for (int i = 0; i < size; ++i) {
            this.definitions.add(this.record.readPrivilegeDef());
        }
    }

    @Override
    protected void doWrite() throws JournalException {
        this.record.writeChar('A');
        this.record.writeInt(this.definitions.size());
        for (PrivilegeDefinition def : this.definitions) {
            this.record.writePrivilegeDef(def);
        }
    }

    @Override
    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    public Collection<PrivilegeDefinition> getDefinitions() {
        return Collections.unmodifiableCollection(this.definitions);
    }
}

