/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.jcache;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelJcacheSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_JCACHE_PATH_CACHE_NAME_CONF = "camel.source.path.cacheName";
    public static final String CAMEL_SOURCE_JCACHE_PATH_CACHE_NAME_DOC = "The name of the cache";
    public static final String CAMEL_SOURCE_JCACHE_PATH_CACHE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_CONF = "camel.source.endpoint.cacheConfiguration";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_DOC = "A Configuration for the Cache";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_PROPERTIES_CONF = "camel.source.endpoint.cacheConfigurationProperties";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_PROPERTIES_DOC = "The Properties for the javax.cache.spi.CachingProvider to create the CacheManager";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHING_PROVIDER_CONF = "camel.source.endpoint.cachingProvider";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHING_PROVIDER_DOC = "The fully qualified class name of the javax.cache.spi.CachingProvider";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHING_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CONFIGURATION_URI_CONF = "camel.source.endpoint.configurationUri";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CONFIGURATION_URI_DOC = "An implementation specific URI for the CacheManager";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CONFIGURATION_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_MANAGEMENT_ENABLED_CONF = "camel.source.endpoint.managementEnabled";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_MANAGEMENT_ENABLED_DOC = "Whether management gathering is enabled";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_MANAGEMENT_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_READ_THROUGH_CONF = "camel.source.endpoint.readThrough";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_READ_THROUGH_DOC = "If read-through caching should be used";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_READ_THROUGH_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_STATISTICS_ENABLED_CONF = "camel.source.endpoint.statisticsEnabled";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_STATISTICS_ENABLED_DOC = "Whether statistics gathering is enabled";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_STATISTICS_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_STORE_BY_VALUE_CONF = "camel.source.endpoint.storeByValue";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_STORE_BY_VALUE_DOC = "If cache should use store-by-value or store-by-reference semantics";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_STORE_BY_VALUE_DEFAULT = true;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_WRITE_THROUGH_CONF = "camel.source.endpoint.writeThrough";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_WRITE_THROUGH_DOC = "If write-through caching should be used";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_WRITE_THROUGH_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_FILTERED_EVENTS_CONF = "camel.source.endpoint.filteredEvents";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_FILTERED_EVENTS_DOC = "Events a consumer should filter (multiple events can be separated by comma). If using filteredEvents option, then eventFilters one will be ignored One of: [CREATED] [UPDATED] [REMOVED] [EXPIRED]";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_FILTERED_EVENTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_OLD_VALUE_REQUIRED_CONF = "camel.source.endpoint.oldValueRequired";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_OLD_VALUE_REQUIRED_DOC = "if the old value is required for events";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_OLD_VALUE_REQUIRED_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_SYNCHRONOUS_DOC = "if the event listener should block the thread causing the event";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EVENT_FILTERS_CONF = "camel.source.endpoint.eventFilters";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EVENT_FILTERS_DOC = "The CacheEntryEventFilter. If using eventFilters option, then filteredEvents one will be ignored";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EVENT_FILTERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_LOADER_FACTORY_CONF = "camel.source.endpoint.cacheLoaderFactory";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_LOADER_FACTORY_DOC = "The CacheLoader factory";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_LOADER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_WRITER_FACTORY_CONF = "camel.source.endpoint.cacheWriterFactory";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_WRITER_FACTORY_DOC = "The CacheWriter factory";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_WRITER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CREATE_CACHE_IF_NOT_EXISTS_CONF = "camel.source.endpoint.createCacheIfNotExists";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_CREATE_CACHE_IF_NOT_EXISTS_DOC = "Configure if a cache need to be created if it does exist or can't be pre-configured.";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_CREATE_CACHE_IF_NOT_EXISTS_DEFAULT = true;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXPIRY_POLICY_FACTORY_CONF = "camel.source.endpoint.expiryPolicyFactory";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXPIRY_POLICY_FACTORY_DOC = "The ExpiryPolicy factory";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_EXPIRY_POLICY_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_LOOKUP_PROVIDERS_CONF = "camel.source.endpoint.lookupProviders";
    public static final String CAMEL_SOURCE_JCACHE_ENDPOINT_LOOKUP_PROVIDERS_DOC = "Configure if a camel-cache should try to find implementations of jcache api in runtimes like OSGi.";
    public static final Boolean CAMEL_SOURCE_JCACHE_ENDPOINT_LOOKUP_PROVIDERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_CONF = "camel.component.jcache.cacheConfiguration";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_DOC = "A Configuration for the Cache";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_CONF = "camel.component.jcache.cacheConfigurationProperties";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_DOC = "Properties to configure jcache";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_REF_CONF = "camel.component.jcache.cacheConfigurationPropertiesRef";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_REF_DOC = "References to an existing Properties or Map to lookup in the registry to use for configuring jcache.";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_REF_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHING_PROVIDER_CONF = "camel.component.jcache.cachingProvider";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHING_PROVIDER_DOC = "The fully qualified class name of the javax.cache.spi.CachingProvider";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CACHING_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CONFIGURATION_URI_CONF = "camel.component.jcache.configurationUri";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CONFIGURATION_URI_DOC = "An implementation specific URI for the CacheManager";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_CONFIGURATION_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.jcache.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JCACHE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.jcache.basicPropertyBinding";
    public static final String CAMEL_SOURCE_JCACHE_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_JCACHE_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelJcacheSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelJcacheSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf(Map<String, String> parsedConfig) {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_JCACHE_PATH_CACHE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_PATH_CACHE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JCACHE_PATH_CACHE_NAME_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_CONFIGURATION_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CACHING_PROVIDER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHING_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHING_PROVIDER_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CONFIGURATION_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_CONFIGURATION_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CONFIGURATION_URI_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_MANAGEMENT_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_MANAGEMENT_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_MANAGEMENT_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_READ_THROUGH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_READ_THROUGH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_READ_THROUGH_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_STATISTICS_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_STATISTICS_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_STATISTICS_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_STORE_BY_VALUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_STORE_BY_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_STORE_BY_VALUE_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_WRITE_THROUGH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_WRITE_THROUGH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_WRITE_THROUGH_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_FILTERED_EVENTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_FILTERED_EVENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_FILTERED_EVENTS_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_OLD_VALUE_REQUIRED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_OLD_VALUE_REQUIRED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_OLD_VALUE_REQUIRED_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_EVENT_FILTERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_EVENT_FILTERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_EVENT_FILTERS_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_LOADER_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_LOADER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_LOADER_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_WRITER_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_WRITER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CACHE_WRITER_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_CREATE_CACHE_IF_NOT_EXISTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_CREATE_CACHE_IF_NOT_EXISTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_CREATE_CACHE_IF_NOT_EXISTS_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_EXPIRY_POLICY_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_ENDPOINT_EXPIRY_POLICY_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_EXPIRY_POLICY_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_ENDPOINT_LOOKUP_PROVIDERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_ENDPOINT_LOOKUP_PROVIDERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_ENDPOINT_LOOKUP_PROVIDERS_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_REF_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_REF_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_CACHE_CONFIGURATION_PROPERTIES_REF_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_CACHING_PROVIDER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_COMPONENT_CACHING_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_CACHING_PROVIDER_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_CONFIGURATION_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JCACHE_COMPONENT_CONFIGURATION_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_CONFIGURATION_URI_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JCACHE_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JCACHE_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JCACHE_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}