/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jcache.JCacheComponent;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheConsumer;
import org.apache.camel.component.jcache.JCacheHelper;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.component.jcache.JCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.17.0", scheme="jcache", title="JCache", syntax="jcache:cacheName", label="cache,datagrid,clustering")
public class JCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="The name of the cache")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final JCacheConfiguration configuration;
    private volatile JCacheManager<Object, Object> cacheManager;

    public JCacheEndpoint(String uri, JCacheComponent component, JCacheConfiguration configuration) {
        super(uri, (Component)component);
        this.cacheName = configuration.getCacheName();
        this.configuration = configuration;
    }

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        return new JCacheProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        JCacheConsumer consumer = new JCacheConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        this.cacheManager = JCacheHelper.createManager(this.configuration);
    }

    protected void doStop() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
    }

    JCacheManager getManager() {
        return this.cacheManager;
    }
}

