/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetScoringUniNode;

public final class BavetScoringUniConstraintStream<Solution_, A>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final BavetAbstractUniConstraintStream<Solution_, A> parent;
    private final BavetConstraint<Solution_> constraint;
    private final boolean noMatchWeigher;
    private final ToIntFunction<A> intMatchWeigher;
    private final ToLongFunction<A> longMatchWeigher;
    private final Function<A, BigDecimal> bigDecimalMatchWeigher;

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, BavetConstraint<Solution_> constraint) {
        this(constraintFactory, parent, constraint, true, null, null, null);
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, BavetConstraint<Solution_> constraint, ToIntFunction<A> intMatchWeigher) {
        this(constraintFactory, parent, constraint, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, BavetConstraint<Solution_> constraint, ToLongFunction<A> longMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, BavetConstraint<Solution_> constraint, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, BavetConstraint<Solution_> constraint, boolean noMatchWeigher, ToIntFunction<A> intMatchWeigher, ToLongFunction<A> longMatchWeigher, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory);
        this.parent = parent;
        this.constraint = constraint;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BavetScoringUniNode<A> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractUniNode<A> parentNode) {
        BiFunction<Object, Consumer, UndoScoreImpacter> scoreImpacter;
        ScoreInliner<Score<?>> scoreInliner = buildPolicy.getSession().getScoreInliner();
        WeightedScoreImpacter weightedScoreImpacter = scoreInliner.buildWeightedScoreImpacter(constraintWeight);
        if (weightedScoreImpacter instanceof IntWeightedScoreImpacter) {
            IntWeightedScoreImpacter intWeightedScoreImpacter = (IntWeightedScoreImpacter)weightedScoreImpacter;
            if (this.intMatchWeigher != null) {
                scoreImpacter = (a, matchScoreConsumer) -> {
                    int matchWeight = this.intMatchWeigher.applyAsInt(a);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return intWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + UniConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return an int.\nMaybe switch to penalize() or reward().");
                scoreImpacter = (a, matchScoreConsumer) -> intWeightedScoreImpacter.impactScore(1, (Consumer<Score<?>>)matchScoreConsumer);
            }
        } else if (weightedScoreImpacter instanceof LongWeightedScoreImpacter) {
            LongWeightedScoreImpacter longWeightedScoreImpacter = (LongWeightedScoreImpacter)weightedScoreImpacter;
            if (this.longMatchWeigher != null) {
                scoreImpacter = (a, matchScoreConsumer) -> {
                    long matchWeight = this.longMatchWeigher.applyAsLong(a);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return longWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + UniConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return a long.\nMaybe switch to penalizeLong() or rewardLong().");
                scoreImpacter = (a, matchScoreConsumer) -> longWeightedScoreImpacter.impactScore(1L, (Consumer<Score<?>>)matchScoreConsumer);
            }
        } else {
            if (!(weightedScoreImpacter instanceof BigDecimalWeightedScoreImpacter)) throw new IllegalStateException("Unsupported weightedScoreImpacter (" + weightedScoreImpacter + ").");
            BigDecimalWeightedScoreImpacter bigDecimalWeightedScoreImpacter = (BigDecimalWeightedScoreImpacter)weightedScoreImpacter;
            if (this.bigDecimalMatchWeigher != null) {
                scoreImpacter = (a, matchScoreConsumer) -> {
                    BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return bigDecimalWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + UniConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return a " + BigDecimal.class.getSimpleName() + ".\nMaybe switch to penalizeBigDecimal() or rewardBigDecimal().");
                scoreImpacter = (a, matchScoreConsumer) -> bigDecimalWeightedScoreImpacter.impactScore(BigDecimal.ONE, (Consumer<Score<?>>)matchScoreConsumer);
            }
        }
        BavetScoringUniNode<Object> bavetScoringUniNode = new BavetScoringUniNode<Object>(buildPolicy.getSession(), buildPolicy.nextNodeIndex(), parentNode, this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), constraintWeight, scoreImpacter);
        buildPolicy.addScoringNode(bavetScoringUniNode);
        return bavetScoringUniNode;
    }

    @Override
    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractUniNode<A> node) {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
    }

    public String toString() {
        return "Scoring()";
    }
}

