/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.factory;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class MoveListFactoryToMoveSelectorBridge<Solution_>
extends AbstractMoveSelector<Solution_>
implements SelectionCacheLifecycleListener<Solution_> {
    protected final MoveListFactory<Solution_> moveListFactory;
    protected final SelectionCacheType cacheType;
    protected final boolean randomSelection;
    protected List<Move<Solution_>> cachedMoveList = null;

    public MoveListFactoryToMoveSelectorBridge(MoveListFactory<Solution_> moveListFactory, SelectionCacheType cacheType, boolean randomSelection) {
        this.moveListFactory = moveListFactory;
        this.cacheType = cacheType;
        this.randomSelection = randomSelection;
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public boolean supportsPhaseAndSolverCaching() {
        return true;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        this.cachedMoveList = this.moveListFactory.createMoveList(solverScope.getScoreDirector().getWorkingSolution());
        this.logger.trace("    Created cachedMoveList: size ({}), moveSelector ({}).", (Object)this.cachedMoveList.size(), (Object)this);
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.cachedMoveList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedMoveList.size();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return this.cachedMoveList.iterator();
        }
        return new CachedListRandomIterator<Move<Solution_>>(this.cachedMoveList, this.workingRandom);
    }

    public String toString() {
        return "MoveListFactory(" + this.moveListFactory.getClass() + ")";
    }
}

