/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.domain.solution.cloner.DeepPlanningClone;
import org.optaplanner.core.impl.domain.common.ConcurrentMemoization;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public final class DeepCloningUtils {
    private final SolutionDescriptor<?> solutionDescriptor;
    private final ConcurrentMap<Pair<Field, Class<?>>, Boolean> fieldDeepClonedMemoization;
    private final ConcurrentMap<Class<?>, Boolean> actualValueClassDeepClonedMemoization;

    public DeepCloningUtils(SolutionDescriptor<?> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        this.fieldDeepClonedMemoization = new ConcurrentMemoization();
        this.actualValueClassDeepClonedMemoization = new ConcurrentMemoization();
    }

    public boolean getDeepCloneDecision(Field field, Class<?> owningClass, Class<?> actualValueClass) {
        Pair pair = Pair.of((Object)field, owningClass);
        Boolean deepCloneDecision = this.fieldDeepClonedMemoization.computeIfAbsent(pair, key -> this.isFieldDeepCloned(field, owningClass));
        return deepCloneDecision != false || this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass)) != false;
    }

    public boolean retrieveDeepCloneDecisionForActualValueClass(Class<?> actualValueClass) {
        return this.actualValueClassDeepClonedMemoization.computeIfAbsent(actualValueClass, key -> this.isClassDeepCloned(actualValueClass));
    }

    public boolean isFieldDeepCloned(Field field, Class<?> owningClass) {
        if (field.getType().isEnum()) {
            return false;
        }
        return this.isFieldAnEntityPropertyOnSolution(field, owningClass) || this.isFieldAnEntityOrSolution(field) || this.isFieldADeepCloneProperty(field, owningClass);
    }

    public boolean isFieldAnEntityPropertyOnSolution(Field field, Class<?> owningClass) {
        if (!this.solutionDescriptor.getSolutionClass().isAssignableFrom(owningClass)) {
            return false;
        }
        String fieldName = field.getName();
        if (this.solutionDescriptor.getEntityMemberAccessorMap().get(fieldName) != null) {
            return true;
        }
        return this.solutionDescriptor.getEntityCollectionMemberAccessorMap().get(fieldName) != null;
    }

    public boolean isFieldAnEntityOrSolution(Field field) {
        Class<?> type = field.getType();
        if (this.isClassDeepCloned(type)) {
            return true;
        }
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) ? this.isTypeArgumentDeepCloned(field.getGenericType()) : type.isArray() && this.isClassDeepCloned(type.getComponentType());
    }

    public boolean isClassDeepCloned(Class<?> type) {
        return this.solutionDescriptor.hasEntityDescriptor(type) || this.solutionDescriptor.getSolutionClass().isAssignableFrom(type) || type.isAnnotationPresent(DeepPlanningClone.class);
    }

    public boolean isTypeArgumentDeepCloned(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof Class && this.isClassDeepCloned((Class)actualTypeArgument)) {
                    return true;
                }
                if (!this.isTypeArgumentDeepCloned(actualTypeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFieldADeepCloneProperty(Field field, Class<?> owningClass) {
        if (field.isAnnotationPresent(DeepPlanningClone.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(owningClass, field.getName());
        return getterMethod != null && getterMethod.isAnnotationPresent(DeepPlanningClone.class);
    }
}

