/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Producer;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enricher
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(Enricher.class);
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private ProducerCache producerCache;
    private final Expression expression;
    private AggregationStrategy aggregationStrategy;
    private boolean aggregateOnException;
    private boolean shareUnitOfWork;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;

    public Enricher(Expression expression) {
        this.expression = expression;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        AsyncProducer producer;
        Endpoint endpoint;
        Object recipient = null;
        boolean prototype = this.cacheSize < 0;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            recipient = Enricher.prepareRecipient(exchange, recipient);
            Endpoint existing = Enricher.getExistingEndpoint(exchange, recipient);
            if (existing == null) {
                endpoint = Enricher.resolveEndpoint(exchange, recipient, prototype);
            } else {
                endpoint = existing;
                prototype = false;
            }
            producer = this.producerCache.acquireProducer(endpoint);
        }
        catch (Throwable e) {
            if (this.isIgnoreInvalidEndpoint()) {
                LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", recipient, (Object)e);
            } else {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        final Exchange resourceExchange = this.createResourceExchange(exchange, ExchangePattern.InOut);
        final Endpoint destination = producer.getEndpoint();
        StopWatch sw = null;
        boolean sending = EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)resourceExchange, (Endpoint)destination);
        if (sending) {
            sw = new StopWatch();
        }
        final StopWatch watch = sw;
        final boolean prototypeEndpoint = prototype;
        AsyncProducer ap = AsyncProcessorConverterHelper.convert((Producer)producer);
        boolean sync = ap.process(resourceExchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                if (watch != null) {
                    long timeTaken = watch.taken();
                    EventHelper.notifyExchangeSent((CamelContext)resourceExchange.getContext(), (Exchange)resourceExchange, (Endpoint)destination, (long)timeTaken);
                }
                if (!Enricher.this.isAggregateOnException() && resourceExchange.isFailed()) {
                    ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)resourceExchange);
                } else {
                    Enricher.prepareResult(exchange);
                    try {
                        ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)resourceExchange);
                        MessageHelper.resetStreamCache((Message)exchange.getIn());
                        Exchange aggregatedExchange = Enricher.this.aggregationStrategy.aggregate(exchange, resourceExchange);
                        if (aggregatedExchange != null) {
                            ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)aggregatedExchange);
                            if (resourceExchange != null) {
                                ((ExtendedExchange)resourceExchange.adapt(ExtendedExchange.class)).handoverCompletions(exchange);
                            }
                        }
                    }
                    catch (Throwable e) {
                        exchange.setException((Throwable)new CamelExchangeException("Error occurred during aggregation", exchange, e));
                        callback.done(false);
                        return;
                    }
                }
                exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)producer.getEndpoint().getEndpointUri());
                try {
                    Enricher.this.producerCache.releaseProducer(endpoint, producer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (prototypeEndpoint) {
                    ServiceHelper.stopAndShutdownService((Object)endpoint);
                }
                callback.done(false);
            }
        });
        if (!sync) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        }
        if (watch != null) {
            long timeTaken = watch.taken();
            EventHelper.notifyExchangeSent((CamelContext)resourceExchange.getContext(), (Exchange)resourceExchange, (Endpoint)destination, (long)timeTaken);
        }
        if (!this.isAggregateOnException() && resourceExchange.isFailed()) {
            ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)resourceExchange);
        } else {
            Enricher.prepareResult(exchange);
            try {
                ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)resourceExchange);
                MessageHelper.resetStreamCache((Message)exchange.getIn());
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)aggregatedExchange);
                }
            }
            catch (Throwable e) {
                exchange.setException((Throwable)new CamelExchangeException("Error occurred during aggregation", exchange, e));
                callback.done(true);
                return true;
            }
        }
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)producer.getEndpoint().getEndpointUri());
        try {
            this.producerCache.releaseProducer(endpoint, producer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prototypeEndpoint) {
            ServiceHelper.stopAndShutdownService((Object)endpoint);
        }
        callback.done(true);
        return true;
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        if (recipient != null) {
            ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
            String uri = recipient instanceof String ? (String)recipient : (String)ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            return ecc.normalizeUri(uri);
        }
        return null;
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof Endpoint) {
            return (Endpoint)recipient;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class);
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString();
            return exchange.getContext().hasEndpoint(uri);
        }
        return null;
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint((Exchange)exchange, (Object)recipient) : ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
    }

    protected Exchange createResourceExchange(Exchange source, ExchangePattern pattern) {
        Exchange target = ExchangeHelper.createCorrelatedCopy((Exchange)source, (boolean)false);
        target.setPattern(pattern);
        if (this.isShareUnitOfWork()) {
            target.setProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, (Object)source.getUnitOfWork());
            ((ExtendedExchange)target.adapt(ExtendedExchange.class)).setUnitOfWork(source.getUnitOfWork());
        }
        return target;
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return this.id;
    }

    protected void doStart() throws Exception {
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = Enricher.defaultAggregationStrategy();
        }
        if (this.aggregationStrategy instanceof CamelContextAware) {
            ((CamelContextAware)this.aggregationStrategy).setCamelContext(this.camelContext);
        }
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache((Object)this, this.camelContext);
                LOG.debug("Enricher {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("Enricher {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService((Object[])new Object[]{this.producerCache, this.aggregationStrategy});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.aggregationStrategy, this.producerCache});
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)oldExchange, (Exchange)newExchange);
            }
            return oldExchange;
        }
    }
}

