/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JBPMEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":connectionURL";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jbpm".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "connectionURL", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "eventListenerType", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("synchronous");
        props.add("contentId");
        props.add("pageSize");
        props.add("workItemId");
        props.add("extraJaxbClasses");
        props.add("timeout");
        props.add("password");
        props.add("maxNumber");
        props.add("bridgeErrorHandler");
        props.add("processId");
        props.add("deploymentId");
        props.add("connectionURL");
        props.add("emitterSendItems");
        props.add("eventListenerType");
        props.add("attachmentId");
        props.add("event");
        props.add("value");
        props.add("identifier");
        props.add("processInstanceId");
        props.add("exchangePattern");
        props.add("targetUserId");
        props.add("eventType");
        props.add("userName");
        props.add("userId");
        props.add("lazyStartProducer");
        props.add("task");
        props.add("entities");
        props.add("statuses");
        props.add("page");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("parameters");
        props.add("taskId");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("userName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

