/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetFilterBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetJoinBridgeBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetScoringBiConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndexFactory;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetJoinTriConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.core.impl.score.stream.bi.InnerBiConstraintStream;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;

public abstract class BavetAbstractBiConstraintStream<Solution_, A, B>
extends BavetAbstractConstraintStream<Solution_>
implements InnerBiConstraintStream<A, B> {
    protected final List<BavetAbstractBiConstraintStream<Solution_, A, B>> childStreamList = new ArrayList<BavetAbstractBiConstraintStream<Solution_, A, B>>(2);

    public BavetAbstractBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory) {
        super(constraintFactory);
    }

    protected void addChildStream(BavetAbstractBiConstraintStream<Solution_, A, B> childStream) {
        this.childStreamList.add(childStream);
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    public BavetAbstractBiConstraintStream<Solution_, A, B> filter(BiPredicate<A, B> predicate) {
        BavetFilterBiConstraintStream stream = new BavetFilterBiConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        if (!(otherStream instanceof BavetAbstractUniConstraintStream)) {
            throw new IllegalStateException("The streams (" + this + ", " + otherStream + ") are not build from the same " + ConstraintFactory.class.getSimpleName() + ".");
        }
        BavetAbstractUniConstraintStream other = (BavetAbstractUniConstraintStream)otherStream;
        if (this.constraintFactory != other.getConstraintFactory()) {
            throw new IllegalStateException("The streams (" + this + ", " + other + ") are build from different constraintFactories (" + this.constraintFactory + ", " + other.getConstraintFactory() + ").");
        }
        if (!(joiner instanceof AbstractTriJoiner)) {
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        AbstractTriJoiner castedJoiner = (AbstractTriJoiner)joiner;
        BavetIndexFactory indexFactory = new BavetIndexFactory(castedJoiner);
        BavetJoinBridgeBiConstraintStream leftBridge = new BavetJoinBridgeBiConstraintStream(this.constraintFactory, this, true, castedJoiner.getLeftCombinedMapping(), indexFactory);
        this.addChildStream(leftBridge);
        BavetJoinBridgeUniConstraintStream rightBridge = new BavetJoinBridgeUniConstraintStream(this.constraintFactory, other, false, castedJoiner.getRightCombinedMapping(), indexFactory);
        other.addChildStream(rightBridge);
        BavetJoinTriConstraintStream joinStream = new BavetJoinTriConstraintStream(this.constraintFactory, leftBridge, rightBridge);
        leftBridge.setJoinStream(joinStream);
        rightBridge.setJoinStream(joinStream);
        return joinStream;
    }

    @Override
    @SafeVarargs
    public final <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SafeVarargs
    public final <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    public BavetAbstractBiNode<A, B> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractBiNode<A, B> parentNode) {
        BavetAbstractBiNode<A, B> node = this.createNode(buildPolicy, constraintWeight, nodeOrder, parentNode);
        node = this.processNode(buildPolicy, nodeOrder, parentNode, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, nodeOrder, node);
        return node;
    }

    protected BavetAbstractBiNode<A, B> processNode(BavetNodeBuildPolicy<Solution_> buildPolicy, int nodeOrder, BavetAbstractBiNode<A, B> parentNode, BavetAbstractBiNode<A, B> node) {
        buildPolicy.updateNodeOrderMaximum(nodeOrder);
        BavetAbstractBiNode<A, B> sharedNode = buildPolicy.retrieveSharedNode(node);
        if (sharedNode != node) {
            node = sharedNode;
        } else if (parentNode != null) {
            parentNode.addChildNode(node);
        }
        return node;
    }

    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractBiNode<A, B> node) {
        if (this.childStreamList.isEmpty()) {
            throw new IllegalStateException("The stream (" + this + ") leads to nowhere.\nMaybe don't create it.");
        }
        for (BavetAbstractBiConstraintStream<Solution_, A, B> childStream : this.childStreamList) {
            childStream.createNodeChain(buildPolicy, constraintWeight, nodeOrder + 1, node);
        }
    }

    protected abstract BavetAbstractBiNode<A, B> createNode(BavetNodeBuildPolicy<Solution_> var1, Score<?> var2, int var3, BavetAbstractBiNode<A, B> var4);
}

