/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.entity.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.custom.CustomShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.CompositeSelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.PinEntityFilter;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDescriptor<Solution_> {
    private static final Class[] VARIABLE_ANNOTATION_CLASSES = new Class[]{PlanningVariable.class, InverseRelationShadowVariable.class, AnchorShadowVariable.class, CustomShadowVariable.class};
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Class<?> entityClass;
    private final Predicate<Object> isInitializedPredicate;
    private SelectionFilter declaredMovableEntitySelectionFilter;
    private SelectionSorter decreasingDifficultySorter;
    private Map<String, GenuineVariableDescriptor<Solution_>> declaredGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor<Solution_>> declaredShadowVariableDescriptorMap;
    private List<SelectionFilter> declaredPinEntityFilterList;
    private List<EntityDescriptor<Solution_>> inheritedEntityDescriptorList;
    private SelectionFilter effectiveMovableEntitySelectionFilter;
    private Map<String, GenuineVariableDescriptor<Solution_>> effectiveGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor<Solution_>> effectiveShadowVariableDescriptorMap;
    private Map<String, VariableDescriptor<Solution_>> effectiveVariableDescriptorMap;

    public EntityDescriptor(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> entityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.entityClass = entityClass;
        this.isInitializedPredicate = this::isInitialized;
        if (entityClass.getPackage() == null) {
            this.logger.warn("The entityClass ({}) should be in a proper java package.", entityClass);
        }
    }

    public Predicate<Object> getIsInitializedPredicate() {
        return this.isInitializedPredicate;
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processEntityAnnotations(descriptorPolicy);
        this.declaredGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor<Solution_>>();
        this.declaredShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor<Solution_>>();
        this.declaredPinEntityFilterList = new ArrayList<SelectionFilter>(2);
        List<Member> memberList = ConfigUtils.getDeclaredMembers(this.entityClass);
        for (Member member : memberList) {
            this.processValueRangeProviderAnnotation(descriptorPolicy, member);
            this.processPlanningVariableAnnotation(descriptorPolicy, member);
            this.processPlanningPinAnnotation(descriptorPolicy, member);
        }
        if (this.declaredGenuineVariableDescriptorMap.isEmpty() && this.declaredShadowVariableDescriptorMap.isEmpty()) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") should have at least 1 getter method or 1 field with a " + PlanningVariable.class.getSimpleName() + " annotation or a shadow variable annotation.");
        }
        this.processVariableAnnotations(descriptorPolicy);
    }

    private void processEntityAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningEntity entityAnnotation = this.entityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has been specified as a planning entity in the configuration, but does not have a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        this.processMovable(descriptorPolicy, entityAnnotation);
        this.processDifficulty(descriptorPolicy, entityAnnotation);
    }

    private void processMovable(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = entityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.declaredMovableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.decreasingDifficultySorter = new ComparatorSelectionSorter(difficultyComparator, SelectionSorterOrder.DESCENDING);
        }
        if (difficultyWeightFactoryClass != null) {
            SelectionSorterWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.decreasingDifficultySorter = new WeightFactorySelectionSorter(difficultyWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    private void processValueRangeProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ValueRangeProvider.class)) {
            MemberAccessor memberAccessor = MemberAccessorFactory.buildMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ValueRangeProvider.class);
            descriptorPolicy.addFromEntityValueRangeProvider(memberAccessor);
        }
    }

    private void processPlanningVariableAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        Class<? extends Annotation> variableAnnotationClass = ConfigUtils.extractAnnotationClass(member, VARIABLE_ANNOTATION_CLASSES);
        if (variableAnnotationClass != null) {
            MemberAccessorFactory.MemberAccessorType memberAccessorType = variableAnnotationClass.equals(CustomShadowVariable.class) ? MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD : MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER;
            MemberAccessor memberAccessor = MemberAccessorFactory.buildMemberAccessor(member, memberAccessorType, variableAnnotationClass);
            this.registerVariableAccessor(descriptorPolicy, variableAnnotationClass, memberAccessor);
        }
    }

    private void registerVariableAccessor(DescriptorPolicy descriptorPolicy, Class<? extends Annotation> variableAnnotationClass, MemberAccessor memberAccessor) {
        String memberName = memberAccessor.getName();
        if (this.declaredGenuineVariableDescriptorMap.containsKey(memberName) || this.declaredShadowVariableDescriptorMap.containsKey(memberName)) {
            VariableDescriptor duplicate = this.declaredGenuineVariableDescriptorMap.get(memberName);
            if (duplicate == null) {
                duplicate = this.declaredShadowVariableDescriptorMap.get(memberName);
            }
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a " + variableAnnotationClass.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member for variableDescriptor (" + duplicate + ").\nMaybe the annotation is defined on both the field and its getter.");
        }
        if (variableAnnotationClass.equals(PlanningVariable.class)) {
            GenuineVariableDescriptor variableDescriptor = new GenuineVariableDescriptor(this, memberAccessor);
            this.declaredGenuineVariableDescriptorMap.put(memberName, variableDescriptor);
        } else if (variableAnnotationClass.equals(InverseRelationShadowVariable.class)) {
            InverseRelationShadowVariableDescriptor variableDescriptor = new InverseRelationShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
        } else if (variableAnnotationClass.equals(AnchorShadowVariable.class)) {
            AnchorShadowVariableDescriptor variableDescriptor = new AnchorShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
        } else if (variableAnnotationClass.equals(CustomShadowVariable.class)) {
            CustomShadowVariableDescriptor variableDescriptor = new CustomShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
        } else {
            throw new IllegalStateException("The variableAnnotationClass (" + variableAnnotationClass + ") is not implemented.");
        }
    }

    private void processPlanningPinAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(PlanningPin.class)) {
            MemberAccessor memberAccessor = MemberAccessorFactory.buildMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningPin.class);
            Class<?> type = memberAccessor.getType();
            if (!Boolean.TYPE.isAssignableFrom(type) && !Boolean.class.isAssignableFrom(type)) {
                throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a " + PlanningPin.class.getSimpleName() + " annotated member (" + memberAccessor + ") that is not a boolean or Boolean.");
            }
            this.declaredPinEntityFilterList.add(new PinEntityFilter(memberAccessor));
        }
    }

    private void processVariableAnnotations(DescriptorPolicy descriptorPolicy) {
        for (GenuineVariableDescriptor<Solution_> genuineVariableDescriptor : this.declaredGenuineVariableDescriptorMap.values()) {
            genuineVariableDescriptor.processAnnotations(descriptorPolicy);
        }
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.processAnnotations(descriptorPolicy);
        }
    }

    public void linkEntityDescriptors(DescriptorPolicy descriptorPolicy) {
        this.investigateParentsToLinkInherited(this.entityClass);
        this.createEffectiveVariableDescriptorMaps();
        this.createEffectiveMovableEntitySelectionFilter();
    }

    private void investigateParentsToLinkInherited(Class<?> investigateClass) {
        this.inheritedEntityDescriptorList = new ArrayList<EntityDescriptor<Solution_>>(4);
        if (investigateClass == null || investigateClass.isArray()) {
            return;
        }
        this.linkInherited(investigateClass.getSuperclass());
        for (Class<?> superInterface : investigateClass.getInterfaces()) {
            this.linkInherited(superInterface);
        }
    }

    private void linkInherited(Class<?> potentialEntityClass) {
        EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.getEntityDescriptorStrict(potentialEntityClass);
        if (entityDescriptor != null) {
            this.inheritedEntityDescriptorList.add(entityDescriptor);
        } else {
            this.investigateParentsToLinkInherited(potentialEntityClass);
        }
    }

    private void createEffectiveVariableDescriptorMaps() {
        this.effectiveGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor<Solution_>>(this.declaredGenuineVariableDescriptorMap.size());
        this.effectiveShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor<Solution_>>(this.declaredShadowVariableDescriptorMap.size());
        for (EntityDescriptor<Solution_> inheritedEntityDescriptor : this.inheritedEntityDescriptorList) {
            this.effectiveGenuineVariableDescriptorMap.putAll(inheritedEntityDescriptor.getGenuineVariableDescriptorMap());
            this.effectiveShadowVariableDescriptorMap.putAll(inheritedEntityDescriptor.getShadowVariableDescriptorMap());
        }
        this.effectiveGenuineVariableDescriptorMap.putAll(this.declaredGenuineVariableDescriptorMap);
        this.effectiveShadowVariableDescriptorMap.putAll(this.declaredShadowVariableDescriptorMap);
        this.effectiveVariableDescriptorMap = new LinkedHashMap<String, VariableDescriptor<Solution_>>(this.effectiveGenuineVariableDescriptorMap.size() + this.effectiveShadowVariableDescriptorMap.size());
        this.effectiveVariableDescriptorMap.putAll(this.effectiveGenuineVariableDescriptorMap);
        this.effectiveVariableDescriptorMap.putAll(this.effectiveShadowVariableDescriptorMap);
    }

    private void createEffectiveMovableEntitySelectionFilter() {
        if (this.declaredMovableEntitySelectionFilter != null && !this.hasAnyDeclaredGenuineVariableDescriptor()) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a movableEntitySelectionFilterClass (" + this.declaredMovableEntitySelectionFilter.getClass() + "), but it has no declared genuine variables, only shadow variables.");
        }
        ArrayList selectionFilterList = new ArrayList();
        for (EntityDescriptor<Solution_> inheritedEntityDescriptor : this.inheritedEntityDescriptorList) {
            if (!inheritedEntityDescriptor.hasEffectiveMovableEntitySelectionFilter()) continue;
            selectionFilterList.add(inheritedEntityDescriptor.getEffectiveMovableEntitySelectionFilter());
        }
        if (this.declaredMovableEntitySelectionFilter != null) {
            selectionFilterList.add(this.declaredMovableEntitySelectionFilter);
        }
        selectionFilterList.addAll(this.declaredPinEntityFilterList);
        this.effectiveMovableEntitySelectionFilter = selectionFilterList.isEmpty() ? null : (selectionFilterList.size() == 1 ? (SelectionFilter)selectionFilterList.get(0) : new CompositeSelectionFilter(selectionFilterList));
    }

    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        for (GenuineVariableDescriptor<Solution_> genuineVariableDescriptor : this.declaredGenuineVariableDescriptorMap.values()) {
            genuineVariableDescriptor.linkVariableDescriptors(descriptorPolicy);
        }
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.linkVariableDescriptors(descriptorPolicy);
        }
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean matchesEntity(Object entity) {
        return this.entityClass.isAssignableFrom(entity.getClass());
    }

    public boolean hasEffectiveMovableEntitySelectionFilter() {
        return this.effectiveMovableEntitySelectionFilter != null;
    }

    public SelectionFilter getEffectiveMovableEntitySelectionFilter() {
        return this.effectiveMovableEntitySelectionFilter;
    }

    public SelectionSorter getDecreasingDifficultySorter() {
        return this.decreasingDifficultySorter;
    }

    public boolean hasAnyDeclaredGenuineVariableDescriptor() {
        return !this.declaredGenuineVariableDescriptorMap.isEmpty();
    }

    public Collection<String> getGenuineVariableNameSet() {
        return this.effectiveGenuineVariableDescriptorMap.keySet();
    }

    public Map<String, GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptorMap() {
        return this.effectiveGenuineVariableDescriptorMap;
    }

    public Collection<GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptors() {
        return this.effectiveGenuineVariableDescriptorMap.values();
    }

    public List<GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptorList() {
        return new ArrayList<GenuineVariableDescriptor<Solution_>>(this.effectiveGenuineVariableDescriptorMap.values());
    }

    public boolean hasGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.containsKey(variableName);
    }

    public GenuineVariableDescriptor<Solution_> getGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.get(variableName);
    }

    public Map<String, ShadowVariableDescriptor<Solution_>> getShadowVariableDescriptorMap() {
        return this.effectiveShadowVariableDescriptorMap;
    }

    public Collection<ShadowVariableDescriptor<Solution_>> getShadowVariableDescriptors() {
        return this.effectiveShadowVariableDescriptorMap.values();
    }

    public boolean hasShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.containsKey(variableName);
    }

    public ShadowVariableDescriptor<Solution_> getShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.get(variableName);
    }

    public Map<String, VariableDescriptor<Solution_>> getVariableDescriptorMap() {
        return this.effectiveVariableDescriptorMap;
    }

    public Collection<VariableDescriptor<Solution_>> getVariableDescriptors() {
        return this.effectiveVariableDescriptorMap.values();
    }

    public boolean hasVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.containsKey(variableName);
    }

    public VariableDescriptor<Solution_> getVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.get(variableName);
    }

    public Collection<GenuineVariableDescriptor<Solution_>> getDeclaredGenuineVariableDescriptors() {
        return this.declaredGenuineVariableDescriptorMap.values();
    }

    public Collection<ShadowVariableDescriptor<Solution_>> getDeclaredShadowVariableDescriptors() {
        return this.declaredShadowVariableDescriptorMap.values();
    }

    public Collection<VariableDescriptor<Solution_>> getDeclaredVariableDescriptors() {
        ArrayList<VariableDescriptor<Solution_>> variableDescriptors = new ArrayList<VariableDescriptor<Solution_>>(this.declaredGenuineVariableDescriptorMap.size() + this.declaredShadowVariableDescriptorMap.size());
        variableDescriptors.addAll(this.declaredGenuineVariableDescriptorMap.values());
        variableDescriptors.addAll(this.declaredShadowVariableDescriptorMap.values());
        return variableDescriptors;
    }

    public String buildInvalidVariableNameExceptionMessage(String variableName) {
        if (!ReflectionHelper.hasGetterMethod(this.entityClass, variableName) && !ReflectionHelper.hasField(this.entityClass, variableName)) {
            String exceptionMessage = "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") does not exists as a getter or field on that class.\nCheck the spelling of the variableName (" + variableName + ").";
            if (variableName.length() >= 2 && !Character.isUpperCase(variableName.charAt(0)) && Character.isUpperCase(variableName.charAt(1))) {
                String correctedVariableName = variableName.substring(0, 1).toUpperCase() + variableName.substring(1);
                exceptionMessage = exceptionMessage + "Maybe it needs to be correctedVariableName (" + correctedVariableName + ") instead, if it's a getter, because the JavaBeans spec states that the first letter should be a upper case if the second is upper case.";
            }
            return exceptionMessage;
        }
        return "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") exists as a getter or field on that class, but isn't in the planning variables (" + this.effectiveVariableDescriptorMap.keySet() + ").\n" + (Character.isUpperCase(variableName.charAt(0)) ? "Maybe the variableName (" + variableName + ") should start with a lowercase.\n" : "") + "Maybe your planning entity's getter or field lacks a " + PlanningVariable.class.getSimpleName() + " annotation or a shadow variable annotation.";
    }

    public boolean hasAnyGenuineVariables() {
        return !this.effectiveGenuineVariableDescriptorMap.isEmpty();
    }

    public boolean hasAnyChainedGenuineVariables() {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isChained()) continue;
            return true;
        }
        return false;
    }

    public List<Object> extractEntities(Solution_ solution) {
        return this.solutionDescriptor.getEntityListByEntityClass(solution, this.entityClass);
    }

    public long getGenuineVariableCount() {
        return this.effectiveGenuineVariableDescriptorMap.size();
    }

    public long getMaximumValueCount(Solution_ solution, Object entity) {
        long maximumValueCount = 0L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            maximumValueCount = Math.max(maximumValueCount, variableDescriptor.getValueCount(solution, entity));
        }
        return maximumValueCount;
    }

    public long getProblemScale(Solution_ solution, Object entity) {
        long problemScale = 1L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            problemScale *= variableDescriptor.getValueCount(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isInitialized(Object entity) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            return false;
        }
        return true;
    }

    public int countReinitializableVariables(ScoreDirector<Solution_> scoreDirector, Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (!variableDescriptor.isReinitializable(scoreDirector, entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isMovable(ScoreDirector<Solution_> scoreDirector, Object entity) {
        return this.effectiveMovableEntitySelectionFilter == null || this.effectiveMovableEntitySelectionFilter.accept(scoreDirector, entity);
    }

    public boolean isEntityInitializedOrImmovable(ScoreDirector<Solution_> scoreDirector, Object entity) {
        return this.isInitialized(entity) || !this.isMovable(scoreDirector, entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityClass.getName() + ")";
    }
}

