/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.List;
import java.util.function.Function;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.common.AbstractConstraint;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsConstraint<Solution_>
extends AbstractConstraint<Solution_, DroolsConstraintFactory<Solution_>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsConstraint.class);
    private final List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList;
    private final DroolsAbstractConstraintStream<Solution_> scoringStream;

    public DroolsConstraint(DroolsConstraintFactory<Solution_> constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, ScoreImpactType scoreImpactType, boolean isConstraintWeightConfigurable, List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList, DroolsAbstractConstraintStream<Solution_> scoringStream) {
        super(constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, scoreImpactType, isConstraintWeightConfigurable);
        this.fromStreamList = fromStreamList;
        this.scoringStream = scoringStream;
    }

    public Rule createRule(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        Rule result = PatternDSL.rule((String)this.getConstraintPackage(), (String)this.getConstraintName()).build(this.scoringStream.createRuleItemBuilders(this, scoreHolderGlobal).toArray(new RuleItemBuilder[0]));
        LOGGER.trace("Constraint stream {} resulted in a new Drools rule: {}.", this.scoringStream, (Object)result);
        return result;
    }

    public Class[] getExpectedJustificationTypes() {
        return this.scoringStream.getExpectedJustificationTypes();
    }

    public String toString() {
        return "DroolsConstraint(" + this.getConstraintId() + ") in " + this.fromStreamList.size() + " from() stream(s)";
    }
}

