/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.instance;

import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.instance.ErrorInfoInstanceList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="request-info-instance")
public class RequestInfoInstance {
    @XmlElement(name="request-instance-id")
    private Long id;
    @XmlElement(name="request-status")
    private String status;
    @XmlElement(name="request-business-key")
    private String businessKey;
    @XmlElement(name="request-message")
    private String message;
    @XmlElement(name="request-retries")
    private Integer retries;
    @XmlElement(name="request-executions")
    private Integer executions;
    @XmlElement(name="request-command")
    private String commandName;
    @XmlElement(name="request-scheduled-date")
    private Date scheduledDate;
    @XmlElement(name="request-data")
    private Map<String, Object> data;
    @XmlElement(name="response-data")
    private Map<String, Object> responseData;
    @XmlElement(name="request-errors")
    private ErrorInfoInstanceList errors;
    @XmlElement(name="request-container-id")
    private String containerId;

    public static Builder builder() {
        return new Builder();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Integer getExecutions() {
        return this.executions;
    }

    public void setExecutions(Integer executions) {
        this.executions = executions;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public Date getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(Date scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public ErrorInfoInstanceList getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorInfoInstanceList errors) {
        this.errors = errors;
    }

    public Map<String, Object> getResponseData() {
        return this.responseData;
    }

    public void setResponseData(Map<String, Object> responseData) {
        this.responseData = responseData;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String toString() {
        return "RequestInfoInstance{id=" + this.id + ", status='" + this.status + '\'' + ", businessKey='" + this.businessKey + '\'' + ", retries=" + this.retries + ", executions=" + this.executions + ", commandName='" + this.commandName + '\'' + ", scheduledDate=" + this.scheduledDate + '}';
    }

    public static class Builder {
        private RequestInfoInstance requestInfoInstance = new RequestInfoInstance();

        public RequestInfoInstance build() {
            return this.requestInfoInstance;
        }

        public Builder id(Long id) {
            this.requestInfoInstance.setId(id);
            return this;
        }

        public Builder status(String status) {
            this.requestInfoInstance.setStatus(status);
            return this;
        }

        public Builder businessKey(String businessKey) {
            this.requestInfoInstance.setBusinessKey(businessKey);
            return this;
        }

        public Builder message(String message) {
            this.requestInfoInstance.setMessage(message);
            return this;
        }

        public Builder retries(Integer retries) {
            this.requestInfoInstance.setRetries(retries);
            return this;
        }

        public Builder executions(Integer executions) {
            this.requestInfoInstance.setExecutions(executions);
            return this;
        }

        public Builder command(String command) {
            this.requestInfoInstance.setCommandName(command);
            return this;
        }

        public Builder scheduledDate(Date date) {
            this.requestInfoInstance.setScheduledDate(date == null ? date : new Date(date.getTime()));
            return this;
        }

        public Builder data(Map<String, Object> data) {
            this.requestInfoInstance.setData(data);
            return this;
        }

        public Builder responseData(Map<String, Object> data) {
            this.requestInfoInstance.setResponseData(data);
            return this;
        }

        public Builder errors(ErrorInfoInstanceList errors) {
            this.requestInfoInstance.setErrors(errors);
            return this;
        }

        public Builder containerId(String containerId) {
            this.requestInfoInstance.setContainerId(containerId);
            return this;
        }
    }
}

