/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.greatdeluge;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class GreatDelugeAcceptor
extends AbstractAcceptor {
    private Score initialWaterLevel;
    private Score waterLevelIncrementScore;
    private Double waterLevelIncrementRatio;
    private Score startingWaterLevel = null;
    private Score currentWaterLevel = null;
    private Double currentWaterLevelRatio = null;

    public Score getWaterLevelIncrementScore() {
        return this.waterLevelIncrementScore;
    }

    public void setWaterLevelIncrementScore(Score waterLevelIncrementScore) {
        this.waterLevelIncrementScore = waterLevelIncrementScore;
    }

    public Score getInitialWaterLevel() {
        return this.initialWaterLevel;
    }

    public void setInitialWaterLevel(Score initialLevel) {
        this.initialWaterLevel = initialLevel;
    }

    public Double getWaterLevelIncrementRatio() {
        return this.waterLevelIncrementRatio;
    }

    public void setWaterLevelIncrementRatio(Double waterLevelIncrementRatio) {
        this.waterLevelIncrementRatio = waterLevelIncrementRatio;
    }

    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        Score score = this.startingWaterLevel = this.initialWaterLevel != null ? this.initialWaterLevel : phaseScope.getBestScore();
        if (this.waterLevelIncrementRatio != null) {
            this.currentWaterLevelRatio = 0.0;
        }
        this.currentWaterLevel = this.startingWaterLevel;
    }

    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.startingWaterLevel = null;
        if (this.waterLevelIncrementRatio != null) {
            this.currentWaterLevelRatio = null;
        }
        this.currentWaterLevel = null;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(this.currentWaterLevel) >= 0) {
            return true;
        }
        Score lastStepScore = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
        return moveScore.compareTo(lastStepScore) > 0;
    }

    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        if (this.waterLevelIncrementScore != null) {
            this.currentWaterLevel = this.currentWaterLevel.add(this.waterLevelIncrementScore);
        } else {
            this.currentWaterLevelRatio = this.currentWaterLevelRatio + this.waterLevelIncrementRatio;
            this.currentWaterLevel = this.startingWaterLevel.add(this.startingWaterLevel.negate().multiply(this.currentWaterLevelRatio));
        }
    }
}

