/*
 * Decompiled with CFR 0.152.
 */
package io.iron.ironmq.keystone;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.iron.ironmq.HttpClient;
import io.iron.ironmq.TokenContainer;
import io.iron.ironmq.keystone.Auth;
import io.iron.ironmq.keystone.KeystoneGetTokenPayload;
import io.iron.ironmq.keystone.KeystoneGetTokenResponse;
import io.iron.ironmq.keystone.PasswordCredentials;
import io.iron.ironmq.keystone.Token;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;

public class KeystoneIdentity
implements TokenContainer {
    String server;
    String tenant;
    String username;
    String password;
    Token tokenInfo;

    protected KeystoneIdentity() {
    }

    public KeystoneIdentity(String server, String tenant, String username, String password) {
        this.server = server;
        this.tenant = tenant;
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getToken() throws IOException {
        if (this.tokenInfo == null || this.tokenInfo.isExpired()) {
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.S").create();
            KeystoneGetTokenPayload payload = new KeystoneGetTokenPayload(new Auth(this.tenant, new PasswordCredentials(this.username, this.password)));
            String body = gson.toJson((Object)payload);
            URL url = new URL(this.server + (this.server.endsWith("/") ? "" : "/") + "tokens");
            String method = "POST";
            HttpClient client = HttpClient.create();
            HashMap<String, String> headers = new HashMap<String, String>(){
                {
                    this.put("Content-Type", "application/json");
                    this.put("Accept", "application/json");
                }
            };
            Reader response = client.singleRequest(method, url, body, headers);
            KeystoneGetTokenResponse tokenResponse = (KeystoneGetTokenResponse)gson.fromJson(response, KeystoneGetTokenResponse.class);
            response.close();
            this.tokenInfo = tokenResponse.getAccess().getToken();
        }
        return this.tokenInfo.getId();
    }

    public static String readFully(Reader reader) throws IOException {
        int numChars;
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }

    public HashMap<String, Object> toHash() {
        return new HashMap<String, Object>(){
            {
                this.put("server", KeystoneIdentity.this.server);
                this.put("tenant", KeystoneIdentity.this.tenant);
                this.put("username", KeystoneIdentity.this.username);
                this.put("password", KeystoneIdentity.this.password);
            }
        };
    }

    public static KeystoneIdentity fromHash(HashMap<String, Object> hash) {
        return new KeystoneIdentity((String)hash.get("server"), (String)hash.get("tenant"), (String)hash.get("username"), (String)hash.get("password"));
    }
}

