/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.multiaddr;

import io.ipfs.multiaddr.Protocol;
import io.ipfs.multihash.Multihash;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;

public class MultiAddress {
    private final byte[] raw;

    public MultiAddress(Multihash hash) {
        this("/ipfs/" + hash.toBase58());
    }

    public MultiAddress(String address) {
        this(MultiAddress.decodeFromString(address));
    }

    public MultiAddress(byte[] raw) {
        MultiAddress.encodeToString(raw);
        this.raw = raw;
    }

    public byte[] getBytes() {
        return Arrays.copyOfRange(this.raw, 0, this.raw.length);
    }

    public boolean isTCPIP() {
        String[] parts = this.toString().substring(1).split("/");
        if (parts.length != 4) {
            return false;
        }
        if (!parts[0].startsWith("ip")) {
            return false;
        }
        return parts[2].equals("tcp");
    }

    public String getHost() {
        String[] parts = this.toString().substring(1).split("/");
        if (parts[0].startsWith("ip")) {
            return parts[1];
        }
        throw new IllegalStateException("This multiaddress doesn't have a host: " + this.toString());
    }

    public int getTCPPort() {
        String[] parts = this.toString().substring(1).split("/");
        if (parts[2].startsWith("tcp")) {
            return Integer.parseInt(parts[3]);
        }
        throw new IllegalStateException("This multiaddress doesn't have a tcp port: " + this.toString());
    }

    private static byte[] decodeFromString(String addr) {
        while (addr.endsWith("/")) {
            addr = addr.substring(0, addr.length() - 1);
        }
        String[] parts = addr.split("/");
        if (parts[0].length() != 0) {
            throw new IllegalStateException("MultiAddress must start with a /");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int i = 1;
            while (i < parts.length) {
                String component;
                String part = parts[i++];
                Protocol p = Protocol.get(part);
                p.appendCode(bout);
                if (p.size() == 0) continue;
                String string = component = p.isTerminal() ? Stream.of(Arrays.copyOfRange(parts, i, parts.length)).reduce("", (a, b) -> a + "/" + b) : parts[i++];
                if (component.length() == 0) {
                    throw new IllegalStateException("Protocol requires address, but non provided!");
                }
                bout.write(p.addressToBytes(component));
                if (!p.isTerminal()) continue;
                break;
            }
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding multiaddress: " + addr);
        }
    }

    private static String encodeToString(byte[] raw) {
        StringBuilder b = new StringBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream(raw);
        try {
            while (true) {
                String addr;
                int code = (int)Protocol.readVarint(in);
                Protocol p = Protocol.get(code);
                b.append("/" + p.name());
                if (p.size() == 0 || (addr = p.readAddress(in)).length() <= 0) continue;
                b.append("/" + addr);
            }
        }
        catch (EOFException code) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return b.toString();
    }

    public String toString() {
        return MultiAddress.encodeToString(this.raw);
    }

    public boolean equals(Object other) {
        if (!(other instanceof MultiAddress)) {
            return false;
        }
        return Arrays.equals(this.raw, ((MultiAddress)other).raw);
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }
}

