/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.multihash;

import io.ipfs.multibase.Base58;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Multihash {
    public final Type type;
    private final byte[] hash;

    public Multihash(Type type, byte[] hash) {
        if (hash.length > 127) {
            throw new IllegalStateException("Unsupported hash size: " + hash.length);
        }
        if (hash.length != type.length) {
            throw new IllegalStateException("Incorrect hash length: " + hash.length + " != " + type.length);
        }
        this.type = type;
        this.hash = hash;
    }

    public Multihash(Multihash toClone) {
        this(toClone.type, toClone.hash);
    }

    public Multihash(byte[] multihash) {
        this(Type.lookup(multihash[0] & 0xFF), Arrays.copyOfRange(multihash, 2, multihash.length));
    }

    public byte[] toBytes() {
        byte[] res = new byte[this.hash.length + 2];
        res[0] = (byte)this.type.index;
        res[1] = (byte)this.hash.length;
        System.arraycopy(this.hash, 0, res, 2, this.hash.length);
        return res;
    }

    public void serialize(DataOutput dout) throws IOException {
        dout.write(this.toBytes());
    }

    public static Multihash deserialize(DataInput din) throws IOException {
        int type = din.readUnsignedByte();
        int len = din.readUnsignedByte();
        Type t = Type.lookup(type);
        byte[] hash = new byte[len];
        din.readFully(hash);
        return new Multihash(t, hash);
    }

    public String toString() {
        return this.toBase58();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multihash)) {
            return false;
        }
        return this.type == ((Multihash)o).type && Arrays.equals(this.hash, ((Multihash)o).hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash) ^ this.type.hashCode();
    }

    public String toHex() {
        StringBuilder res = new StringBuilder();
        for (byte b : this.toBytes()) {
            res.append(String.format("%x", b & 0xFF));
        }
        return res.toString();
    }

    public String toBase58() {
        return Base58.encode((byte[])this.toBytes());
    }

    public static Multihash fromHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalStateException("Uneven number of hex digits!");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            bout.write(Integer.valueOf(hex.substring(i, i + 2), 16));
        }
        return new Multihash(bout.toByteArray());
    }

    public static Multihash fromBase58(String base58) {
        return new Multihash(Base58.decode((String)base58));
    }

    public static enum Type {
        sha1(17, 20),
        sha2_256(18, 32),
        sha2_512(19, 64),
        sha3(20, 64),
        blake2b(64, 64),
        blake2s(65, 32);

        public int index;
        public int length;
        private static Map<Integer, Type> lookup;

        private Type(int index, int length) {
            this.index = index;
            this.length = length;
        }

        public static Type lookup(int t) {
            if (!lookup.containsKey(t)) {
                throw new IllegalStateException("Unknown Multihash type: " + t);
            }
            return lookup.get(t);
        }

        static {
            lookup = new TreeMap<Integer, Type>();
            for (Type t : Type.values()) {
                lookup.put(t.index, t);
            }
        }
    }
}

