/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import io.ipfs.api.JSONParser;
import io.ipfs.api.KeyInfo;
import io.ipfs.api.MerkleNode;
import io.ipfs.api.Multipart;
import io.ipfs.api.NamedStreamable;
import io.ipfs.api.Peer;
import io.ipfs.api.Version;
import io.ipfs.cid.Cid;
import io.ipfs.multiaddr.MultiAddress;
import io.ipfs.multihash.Multihash;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IPFS {
    public static final Version MIN_VERSION = Version.parse("0.4.11");
    public List<String> ObjectTemplates = Arrays.asList("unixfs-dir");
    public List<String> ObjectPatchTypes = Arrays.asList("add-link", "rm-link", "set-data", "append-data");
    public final String host;
    public final int port;
    public final String protocol;
    private final String version;
    public final Key key = new Key();
    public final Pin pin = new Pin();
    public final Repo repo = new Repo();
    public final IPFSObject object = new IPFSObject();
    public final Swarm swarm = new Swarm();
    public final Bootstrap bootstrap = new Bootstrap();
    public final Block block = new Block();
    public final Dag dag = new Dag();
    public final Diag diag = new Diag();
    public final Config config = new Config();
    public final Refs refs = new Refs();
    public final Update update = new Update();
    public final DHT dht = new DHT();
    public final File file = new File();
    public final Stats stats = new Stats();
    public final Name name = new Name();
    public final Pubsub pubsub = new Pubsub();

    public IPFS(String host, int port) {
        this(host, port, "/api/v0/", false);
    }

    public IPFS(String multiaddr) {
        this(new MultiAddress(multiaddr));
    }

    public IPFS(MultiAddress addr) {
        this(addr.getHost(), addr.getTCPPort(), "/api/v0/", IPFS.detectSSL(addr));
    }

    public IPFS(String host, int port, String version, boolean ssl) {
        this.host = host;
        this.port = port;
        this.protocol = ssl ? "https" : "http";
        this.version = version;
        try {
            Version detected = Version.parse(this.version());
            if (detected.isBefore(MIN_VERSION)) {
                throw new IllegalStateException("You need to use a more recent version of IPFS! >= " + MIN_VERSION);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<MerkleNode> add(NamedStreamable file) throws IOException {
        return this.add(file, false);
    }

    public List<MerkleNode> add(NamedStreamable file, boolean wrap) throws IOException {
        return this.add(file, wrap, false);
    }

    public List<MerkleNode> add(NamedStreamable file, boolean wrap, boolean hashOnly) throws IOException {
        return this.add(Collections.singletonList(file), wrap, hashOnly);
    }

    public List<MerkleNode> add(List<NamedStreamable> files, boolean wrap, boolean hashOnly) throws IOException {
        Multipart m = new Multipart(this.protocol + "://" + this.host + ":" + this.port + this.version + "add?stream-channels=true&w=" + wrap + "&n=" + hashOnly, "UTF-8");
        for (NamedStreamable file : files) {
            if (file.isDirectory()) {
                m.addSubtree(Paths.get("", new String[0]), file);
                continue;
            }
            m.addFilePart("file", Paths.get("", new String[0]), file);
        }
        String res = m.finish();
        return JSONParser.parseStream(res).stream().map(x -> MerkleNode.fromJSON((Map)x)).collect(Collectors.toList());
    }

    public List<MerkleNode> ls(Multihash hash) throws IOException {
        Map res = this.retrieveMap("ls?arg=" + hash);
        return ((List)res.get("Objects")).stream().map(x -> MerkleNode.fromJSON((Map)x)).collect(Collectors.toList());
    }

    public byte[] cat(Multihash hash) throws IOException {
        return this.retrieve("cat?arg=" + hash);
    }

    public byte[] cat(Multihash hash, String subPath) throws IOException {
        return this.retrieve("cat?arg=" + hash + URLEncoder.encode(subPath, "UTF-8"));
    }

    public byte[] get(Multihash hash) throws IOException {
        return this.retrieve("get?arg=" + hash);
    }

    public InputStream catStream(Multihash hash) throws IOException {
        return this.retrieveStream("cat?arg=" + hash);
    }

    public List<Multihash> refs(Multihash hash, boolean recursive) throws IOException {
        String jsonStream = new String(this.retrieve("refs?arg=" + hash + "&r=" + recursive));
        return JSONParser.parseStream(jsonStream).stream().map(m -> (String)((Map)m).get("Ref")).map(Cid::decode).collect(Collectors.toList());
    }

    public Map resolve(String scheme, Multihash hash, boolean recursive) throws IOException {
        return this.retrieveMap("resolve?arg=/" + scheme + "/" + hash + "&r=" + recursive);
    }

    public String dns(String domain) throws IOException {
        Map res = this.retrieveMap("dns?arg=" + domain);
        return (String)res.get("Path");
    }

    public Map mount(java.io.File ipfsRoot, java.io.File ipnsRoot) throws IOException {
        if (ipfsRoot != null && !ipfsRoot.exists()) {
            ipfsRoot.mkdirs();
        }
        if (ipnsRoot != null && !ipnsRoot.exists()) {
            ipnsRoot.mkdirs();
        }
        return (Map)this.retrieveAndParse("mount?arg=" + (ipfsRoot != null ? ipfsRoot.getPath() : "/ipfs") + "&arg=" + (ipnsRoot != null ? ipnsRoot.getPath() : "/ipns"));
    }

    public List<MultiAddress> bootstrap() throws IOException {
        return ((List)this.retrieveMap("bootstrap/").get("Peers")).stream().flatMap(x -> {
            try {
                return Stream.of(new MultiAddress(x));
            }
            catch (Exception e) {
                return Stream.empty();
            }
        }).collect(Collectors.toList());
    }

    public Map ping(Multihash target) throws IOException {
        return this.retrieveMap("ping/" + target.toBase58());
    }

    public Map id(Multihash target) throws IOException {
        return this.retrieveMap("id/" + target.toBase58());
    }

    public Map id() throws IOException {
        return this.retrieveMap("id");
    }

    public String version() throws IOException {
        Map m = (Map)this.retrieveAndParse("version");
        return (String)m.get("Version");
    }

    public Map commands() throws IOException {
        return this.retrieveMap("commands");
    }

    public Map log() throws IOException {
        return this.retrieveMap("log/tail");
    }

    public Object update() throws IOException {
        return this.retrieveAndParse("update");
    }

    private Map retrieveMap(String path) throws IOException {
        return (Map)this.retrieveAndParse(path);
    }

    private Object retrieveAndParse(String path) throws IOException {
        byte[] res = this.retrieve(path);
        return JSONParser.parse(new String(res));
    }

    private Stream<Object> retrieveAndParseStream(String path, ForkJoinPool executor) throws IOException {
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        InputStream in = this.retrieveStream(path);
        executor.submit(() -> this.getObjectStream(in, res -> results.add(CompletableFuture.completedFuture(res)), err -> {
            CompletableFuture fut = new CompletableFuture();
            fut.completeExceptionally((Throwable)err);
            results.add(fut);
        }));
        return Stream.generate(() -> {
            try {
                return JSONParser.parse(new String((byte[])((CompletableFuture)results.take()).get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void retrieveAndParseStream(String path, Consumer<Object> results, Consumer<IOException> err) throws IOException {
        this.getObjectStream(this.retrieveStream(path), d -> results.accept(JSONParser.parse(new String((byte[])d))), err);
    }

    private byte[] retrieve(String path) throws IOException {
        URL target = new URL(this.protocol, this.host, this.port, this.version + path);
        return IPFS.get(target);
    }

    private static byte[] get(URL target) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)target.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        try {
            int r;
            InputStream in = conn.getInputStream();
            ByteArrayOutputStream resp = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((r = in.read(buf)) >= 0) {
                resp.write(buf, 0, r);
            }
            return resp.toByteArray();
        }
        catch (ConnectException e) {
            throw new RuntimeException("Couldn't connect to IPFS daemon at " + target + "\n Is IPFS running?");
        }
        catch (IOException e) {
            String err = new String(IPFS.readFully(conn.getErrorStream()));
            throw new RuntimeException("IOException contacting IPFS daemon.\nTrailer: " + conn.getHeaderFields().get("Trailer") + " " + err, e);
        }
    }

    private void getObjectStream(InputStream in, Consumer<byte[]> processor, Consumer<IOException> error) {
        byte LINE_FEED = 10;
        try {
            int r;
            ByteArrayOutputStream resp = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((r = in.read(buf)) >= 0) {
                resp.write(buf, 0, r);
                if (buf[r - 1] != LINE_FEED) continue;
                processor.accept(resp.toByteArray());
                resp.reset();
            }
        }
        catch (IOException e) {
            error.accept(e);
        }
    }

    private InputStream retrieveStream(String path) throws IOException {
        URL target = new URL("http", this.host, this.port, this.version + path);
        return IPFS.getStream(target);
    }

    private static InputStream getStream(URL target) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)target.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        return conn.getInputStream();
    }

    private Map postMap(String path, byte[] body, Map<String, String> headers) throws IOException {
        URL target = new URL(this.protocol, this.host, this.port, this.version + path);
        return (Map)JSONParser.parse(new String(IPFS.post(target, body, headers)));
    }

    private static byte[] post(URL target, byte[] body, Map<String, String> headers) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)target.openConnection();
        for (String key : headers.keySet()) {
            conn.setRequestProperty(key, headers.get(key));
        }
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        OutputStream out = conn.getOutputStream();
        out.write(body);
        out.flush();
        out.close();
        InputStream in = conn.getInputStream();
        return IPFS.readFully(in);
    }

    private static final byte[] readFully(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream resp = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) >= 0) {
            resp.write(buf, 0, r);
        }
        return resp.toByteArray();
    }

    private static boolean detectSSL(MultiAddress multiaddress) {
        return multiaddress.toString().contains("/https");
    }

    public class Update {
        public Object check() throws IOException {
            return IPFS.this.retrieveAndParse("update/check");
        }

        public Object log() throws IOException {
            return IPFS.this.retrieveAndParse("update/log");
        }
    }

    public class Config {
        public Map show() throws IOException {
            return (Map)IPFS.this.retrieveAndParse("config/show");
        }

        public void replace(NamedStreamable file) throws IOException {
            Multipart m = new Multipart(IPFS.this.protocol + "://" + IPFS.this.host + ":" + IPFS.this.port + IPFS.this.version + "config/replace?stream-channels=true", "UTF-8");
            m.addFilePart("file", Paths.get("", new String[0]), file);
            String res = m.finish();
        }

        public String get(String key) throws IOException {
            Map m = (Map)IPFS.this.retrieveAndParse("config?arg=" + key);
            return (String)m.get("Value");
        }

        public Map set(String key, String value) throws IOException {
            return IPFS.this.retrieveMap("config?arg=" + key + "&arg=" + value);
        }
    }

    public class Stats {
        public Map bw() throws IOException {
            return IPFS.this.retrieveMap("stats/bw");
        }
    }

    public class Diag {
        public String cmds() throws IOException {
            return new String(IPFS.this.retrieve("diag/cmds?stream-channels=true"));
        }

        public String sys() throws IOException {
            return new String(IPFS.this.retrieve("diag/sys?stream-channels=true"));
        }
    }

    public class Dag {
        public byte[] get(Cid cid) throws IOException {
            return IPFS.this.retrieve("dag/get?stream-channels=true&arg=" + cid);
        }

        public MerkleNode put(byte[] object) throws IOException {
            return this.put("json", object, "cbor");
        }

        public MerkleNode put(String inputFormat, byte[] object) throws IOException {
            return this.put(inputFormat, object, "cbor");
        }

        public MerkleNode put(byte[] object, String outputFormat) throws IOException {
            return this.put("json", object, outputFormat);
        }

        public MerkleNode put(String inputFormat, byte[] object, String outputFormat) throws IOException {
            String prefix = IPFS.this.protocol + "://" + IPFS.this.host + ":" + IPFS.this.port + IPFS.this.version;
            Multipart m = new Multipart(prefix + "dag/put/?stream-channels=true&input-enc=" + inputFormat + "&f=" + outputFormat, "UTF-8");
            m.addFilePart("file", Paths.get("", new String[0]), new NamedStreamable.ByteArrayWrapper(object));
            String res = m.finish();
            return MerkleNode.fromJSON(JSONParser.parse(res));
        }
    }

    public class Swarm {
        public List<Peer> peers() throws IOException {
            Map m = IPFS.this.retrieveMap("swarm/peers?stream-channels=true");
            return ((List)m.get("Peers")).stream().flatMap(json -> {
                try {
                    return Stream.of(Peer.fromJSON(json));
                }
                catch (Exception e) {
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
        }

        public Map<Multihash, List<MultiAddress>> addrs() throws IOException {
            Map m = IPFS.this.retrieveMap("swarm/addrs?stream-channels=true");
            return ((Map)m.get("Addrs")).entrySet().stream().collect(Collectors.toMap(e -> Multihash.fromBase58((String)((String)e.getKey())), e -> ((List)e.getValue()).stream().map(MultiAddress::new).collect(Collectors.toList())));
        }

        public Map connect(MultiAddress multiAddr) throws IOException {
            Map m = IPFS.this.retrieveMap("swarm/connect?arg=" + multiAddr);
            return m;
        }

        public Map disconnect(MultiAddress multiAddr) throws IOException {
            Map m = IPFS.this.retrieveMap("swarm/disconnect?arg=" + multiAddr);
            return m;
        }
    }

    public class Bootstrap {
        public List<MultiAddress> list() throws IOException {
            return IPFS.this.bootstrap();
        }

        public List<MultiAddress> add(MultiAddress addr) throws IOException {
            return ((List)IPFS.this.retrieveMap("bootstrap/add?arg=" + addr).get("Peers")).stream().map(x -> new MultiAddress(x)).collect(Collectors.toList());
        }

        public List<MultiAddress> rm(MultiAddress addr) throws IOException {
            return this.rm(addr, false);
        }

        public List<MultiAddress> rm(MultiAddress addr, boolean all) throws IOException {
            return ((List)IPFS.this.retrieveMap("bootstrap/rm?" + (all ? "all=true&" : "") + "arg=" + addr).get("Peers")).stream().map(x -> new MultiAddress(x)).collect(Collectors.toList());
        }
    }

    public class File {
        public Map ls(Multihash path) throws IOException {
            return IPFS.this.retrieveMap("file/ls?arg=" + path);
        }
    }

    public class DHT {
        public Map findprovs(Multihash hash) throws IOException {
            return IPFS.this.retrieveMap("dht/findprovs?arg=" + hash);
        }

        public Map query(Multihash peerId) throws IOException {
            return IPFS.this.retrieveMap("dht/query?arg=" + peerId.toString());
        }

        public Map findpeer(Multihash id) throws IOException {
            return IPFS.this.retrieveMap("dht/findpeer?arg=" + id.toString());
        }

        public Map get(Multihash hash) throws IOException {
            return IPFS.this.retrieveMap("dht/get?arg=" + hash);
        }

        public Map put(String key, String value) throws IOException {
            return IPFS.this.retrieveMap("dht/put?arg=" + key + "&arg=" + value);
        }
    }

    public class Name {
        public Map publish(Multihash hash) throws IOException {
            return this.publish(hash, Optional.empty());
        }

        public Map publish(Multihash hash, Optional<String> id) throws IOException {
            return IPFS.this.retrieveMap("name/publish?arg=/ipfs/" + hash + id.map(name -> "&key=" + name).orElse(""));
        }

        public String resolve(Multihash hash) throws IOException {
            Map res = (Map)IPFS.this.retrieveAndParse("name/resolve?arg=" + hash);
            return (String)res.get("Path");
        }
    }

    public class IPFSObject {
        public List<MerkleNode> put(List<byte[]> data) throws IOException {
            Multipart m = new Multipart(IPFS.this.protocol + "://" + IPFS.this.host + ":" + IPFS.this.port + IPFS.this.version + "object/put?stream-channels=true", "UTF-8");
            for (byte[] f : data) {
                m.addFilePart("file", Paths.get("", new String[0]), new NamedStreamable.ByteArrayWrapper(f));
            }
            String res = m.finish();
            return JSONParser.parseStream(res).stream().map(x -> MerkleNode.fromJSON((Map)x)).collect(Collectors.toList());
        }

        public List<MerkleNode> put(String encoding, List<byte[]> data) throws IOException {
            if (!"json".equals(encoding) && !"protobuf".equals(encoding)) {
                throw new IllegalArgumentException("Encoding must be json or protobuf");
            }
            Multipart m = new Multipart(IPFS.this.protocol + "://" + IPFS.this.host + ":" + IPFS.this.port + IPFS.this.version + "object/put?stream-channels=true&encoding=" + encoding, "UTF-8");
            for (byte[] f : data) {
                m.addFilePart("file", Paths.get("", new String[0]), new NamedStreamable.ByteArrayWrapper(f));
            }
            String res = m.finish();
            return JSONParser.parseStream(res).stream().map(x -> MerkleNode.fromJSON((Map)x)).collect(Collectors.toList());
        }

        public MerkleNode get(Multihash hash) throws IOException {
            Map json = IPFS.this.retrieveMap("object/get?stream-channels=true&arg=" + hash);
            json.put("Hash", hash.toBase58());
            return MerkleNode.fromJSON(json);
        }

        public MerkleNode links(Multihash hash) throws IOException {
            Map json = IPFS.this.retrieveMap("object/links?stream-channels=true&arg=" + hash);
            return MerkleNode.fromJSON(json);
        }

        public Map<String, Object> stat(Multihash hash) throws IOException {
            return IPFS.this.retrieveMap("object/stat?stream-channels=true&arg=" + hash);
        }

        public byte[] data(Multihash hash) throws IOException {
            return IPFS.this.retrieve("object/data?stream-channels=true&arg=" + hash);
        }

        public MerkleNode _new(Optional<String> template) throws IOException {
            if (template.isPresent() && !IPFS.this.ObjectTemplates.contains(template.get())) {
                throw new IllegalStateException("Unrecognised template: " + template.get());
            }
            Map json = IPFS.this.retrieveMap("object/new?stream-channels=true" + (template.isPresent() ? "&arg=" + template.get() : ""));
            return MerkleNode.fromJSON(json);
        }

        public MerkleNode patch(Multihash base, String command, Optional<byte[]> data, Optional<String> name, Optional<Multihash> target) throws IOException {
            if (!IPFS.this.ObjectPatchTypes.contains(command)) {
                throw new IllegalStateException("Illegal Object.patch command type: " + command);
            }
            String targetPath = "object/patch/" + command + "?arg=" + base.toBase58();
            if (name.isPresent()) {
                targetPath = targetPath + "&arg=" + name.get();
            }
            if (target.isPresent()) {
                targetPath = targetPath + "&arg=" + target.get().toBase58();
            }
            switch (command) {
                case "add-link": {
                    if (!target.isPresent()) {
                        throw new IllegalStateException("add-link requires name and target!");
                    }
                }
                case "rm-link": {
                    if (!name.isPresent()) {
                        throw new IllegalStateException("link name is required!");
                    }
                    return MerkleNode.fromJSON(IPFS.this.retrieveMap(targetPath));
                }
                case "set-data": 
                case "append-data": {
                    if (!data.isPresent()) {
                        throw new IllegalStateException("set-data requires data!");
                    }
                    Multipart m = new Multipart(IPFS.this.protocol + "://" + IPFS.this.host + ":" + IPFS.this.port + IPFS.this.version + "object/patch/" + command + "?arg=" + base.toBase58() + "&stream-channels=true", "UTF-8");
                    m.addFilePart("file", Paths.get("", new String[0]), new NamedStreamable.ByteArrayWrapper(data.get()));
                    String res = m.finish();
                    return MerkleNode.fromJSON(JSONParser.parse(res));
                }
            }
            throw new IllegalStateException("Unimplemented");
        }
    }

    public class Block {
        public byte[] get(Multihash hash) throws IOException {
            return IPFS.this.retrieve("block/get?stream-channels=true&arg=" + hash);
        }

        public List<MerkleNode> put(List<byte[]> data) throws IOException {
            return this.put(data, Optional.empty());
        }

        public List<MerkleNode> put(List<byte[]> data, Optional<String> format) throws IOException {
            ArrayList<MerkleNode> res = new ArrayList<MerkleNode>();
            for (byte[] value : data) {
                res.add(this.put(value, format));
            }
            return res;
        }

        public MerkleNode put(byte[] data, Optional<String> format) throws IOException {
            String fmt = format.map(f -> "&format=" + f).orElse("");
            Multipart m = new Multipart(IPFS.this.protocol + "://" + IPFS.this.host + ":" + IPFS.this.port + IPFS.this.version + "block/put?stream-channels=true" + fmt, "UTF-8");
            try {
                m.addFilePart("file", Paths.get("", new String[0]), new NamedStreamable.ByteArrayWrapper(data));
                String res = m.finish();
                return JSONParser.parseStream(res).stream().map(x -> MerkleNode.fromJSON((Map)x)).findFirst().get();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Map stat(Multihash hash) throws IOException {
            return IPFS.this.retrieveMap("block/stat?stream-channels=true&arg=" + hash);
        }
    }

    public class Pubsub {
        public Object ls() throws IOException {
            return IPFS.this.retrieveAndParse("pubsub/ls");
        }

        public Object peers() throws IOException {
            return IPFS.this.retrieveAndParse("pubsub/peers");
        }

        public Object peers(String topic) throws IOException {
            return IPFS.this.retrieveAndParse("pubsub/peers?arg=" + topic);
        }

        public Object pub(String topic, String data) throws Exception {
            return IPFS.this.retrieveAndParse("pubsub/pub?arg=" + topic + "&arg=" + data);
        }

        public Stream<Map<String, Object>> sub(String topic) throws Exception {
            return this.sub(topic, ForkJoinPool.commonPool());
        }

        public Stream<Map<String, Object>> sub(String topic, ForkJoinPool threadSupplier) throws Exception {
            return IPFS.this.retrieveAndParseStream("pubsub/sub?arg=" + topic, threadSupplier).map(obj -> (Map)obj);
        }

        public void sub(String topic, Consumer<Map<String, Object>> results, Consumer<IOException> error) throws IOException {
            IPFS.this.retrieveAndParseStream("pubsub/sub?arg=" + topic, res -> results.accept((Map)res), error);
        }
    }

    public class Repo {
        public Object gc() throws IOException {
            return IPFS.this.retrieveAndParse("repo/gc");
        }
    }

    public class Key {
        public KeyInfo gen(String name, Optional<String> type, Optional<String> size) throws IOException {
            return KeyInfo.fromJson(IPFS.this.retrieveAndParse("key/gen?arg=" + name + type.map(t -> "&type=" + t).orElse("") + size.map(s -> "&size=" + s).orElse("")));
        }

        public List<KeyInfo> list() throws IOException {
            return ((List)((Map)IPFS.this.retrieveAndParse("key/list")).get("Keys")).stream().map(KeyInfo::fromJson).collect(Collectors.toList());
        }

        public Object rename(String name, String newName) throws IOException {
            return IPFS.this.retrieveAndParse("key/rename?arg=" + name + "&arg=" + newName);
        }

        public List<KeyInfo> rm(String name) throws IOException {
            return ((List)((Map)IPFS.this.retrieveAndParse("key/rm?arg=" + name)).get("Keys")).stream().map(KeyInfo::fromJson).collect(Collectors.toList());
        }
    }

    public class Pin {
        public List<Multihash> add(Multihash hash) throws IOException {
            return ((List)((Map)IPFS.this.retrieveAndParse("pin/add?stream-channels=true&arg=" + hash)).get("Pins")).stream().map(x -> Cid.decode((String)((String)x))).collect(Collectors.toList());
        }

        public Map<Multihash, Object> ls() throws IOException {
            return this.ls(PinType.direct);
        }

        public Map<Multihash, Object> ls(PinType type) throws IOException {
            return ((Map)((Map)IPFS.this.retrieveAndParse("pin/ls?stream-channels=true&t=" + type.name())).get("Keys")).entrySet().stream().collect(Collectors.toMap(x -> Cid.decode((String)((String)x.getKey())), x -> x.getValue()));
        }

        public List<Multihash> rm(Multihash hash) throws IOException {
            return this.rm(hash, true);
        }

        public List<Multihash> rm(Multihash hash, boolean recursive) throws IOException {
            Map json = IPFS.this.retrieveMap("pin/rm?stream-channels=true&r=" + recursive + "&arg=" + hash);
            return ((List)json.get("Pins")).stream().map(x -> Cid.decode((String)((String)x))).collect(Collectors.toList());
        }

        public List<MultiAddress> update(Multihash existing, Multihash modified, boolean unpin) throws IOException {
            return ((List)((Map)IPFS.this.retrieveAndParse("pin/update?stream-channels=true&arg=" + existing + "&arg=" + modified + "&unpin=" + unpin)).get("Pins")).stream().map(x -> new MultiAddress((String)x)).collect(Collectors.toList());
        }
    }

    public class Refs {
        public List<Multihash> local() throws IOException {
            String jsonStream = new String(IPFS.this.retrieve("refs/local"));
            return JSONParser.parseStream(jsonStream).stream().map(m -> (String)((Map)m).get("Ref")).map(Cid::decode).collect(Collectors.toList());
        }
    }

    public static enum PinType {
        all,
        direct,
        indirect,
        recursive;

    }
}

