/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import io.ipfs.api.JSONParser;
import io.ipfs.api.Pair;
import io.ipfs.api.cbor.CborObject;
import io.ipfs.api.cbor.Cborable;
import io.ipfs.cid.Cid;
import io.ipfs.multihash.Multihash;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface IpldNode
extends Cborable {
    public Pair<IpldNode, List<String>> resolve(List<String> var1);

    public List<String> tree(String var1, int var2);

    default public Cid cid() {
        byte[] raw = this.rawData();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(raw);
            byte[] digest = md.digest();
            Multihash h = new Multihash(Multihash.Type.sha2_256, digest);
            return new Cid(1L, Cid.Codec.DagCbor, h);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public long size();

    public byte[] rawData();

    public List<Link> getLinks();

    public static IpldNode fromCBOR(CborObject cbor) {
        return new CborIpldNode(cbor);
    }

    public static IpldNode fromJSON(Object json) {
        return new JsonIpldNode(json);
    }

    public static class Link {
        public final String name;
        public final long size;
        public final Multihash target;

        public Link(String name, long size, Multihash target) {
            this.name = name;
            this.size = size;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            if (this.size != link.size) {
                return false;
            }
            if (this.name != null ? !this.name.equals(link.name) : link.name != null) {
                return false;
            }
            return this.target != null ? this.target.equals((Object)link.target) : link.target == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }

    public static class JsonIpldNode
    implements IpldNode {
        private final Object json;

        public JsonIpldNode(Object json) {
            this.json = json;
        }

        @Override
        public CborObject toCbor() {
            throw new IllegalStateException("Unimplemented!");
        }

        @Override
        public Pair<IpldNode, List<String>> resolve(List<String> path) {
            throw new IllegalStateException("Unimplemented!");
        }

        @Override
        public List<String> tree(String path, int depth) {
            throw new IllegalStateException("Unimplemented!");
        }

        @Override
        public long size() {
            return this.rawData().length;
        }

        @Override
        public byte[] rawData() {
            return JSONParser.toString(this.json).getBytes();
        }

        @Override
        public List<Link> getLinks() {
            throw new IllegalStateException("Unimplemented!");
        }
    }

    public static class CborIpldNode
    implements IpldNode {
        private final CborObject base;

        public CborIpldNode(CborObject base) {
            this.base = base;
        }

        @Override
        public CborObject toCbor() {
            return this.base;
        }

        @Override
        public Pair<IpldNode, List<String>> resolve(List<String> path) {
            throw new IllegalStateException("Unimplemented!");
        }

        @Override
        public List<String> tree(String path, int depth) {
            return this.tree(this.base, path, depth);
        }

        private List<String> tree(CborObject base, String rawPath, int depth) {
            String path;
            String string = path = rawPath.startsWith("/") ? rawPath.substring(1) : rawPath;
            if (depth == 0 || path.equals("") && depth != -1) {
                return Collections.singletonList("");
            }
            if (base instanceof CborObject.CborMap) {
                return ((CborObject.CborMap)base).values.entrySet().stream().flatMap(e -> {
                    String name = ((CborObject.CborString)e.getKey()).value;
                    if (path.startsWith(name) || depth == -1) {
                        return this.tree((CborObject)e.getValue(), path.length() > 0 ? path.substring(name.length()) : path, depth == -1 ? -1 : depth - 1).stream().map(p -> "/" + name + p);
                    }
                    return Stream.empty();
                }).collect(Collectors.toList());
            }
            if (depth == -1) {
                return Collections.singletonList("");
            }
            return Collections.emptyList();
        }

        @Override
        public long size() {
            return this.rawData().length;
        }

        @Override
        public byte[] rawData() {
            return this.base.toByteArray();
        }

        @Override
        public List<Link> getLinks() {
            return CborIpldNode.getLinks(this.base);
        }

        private static List<Link> getLinks(CborObject base) {
            if (base instanceof CborObject.CborMerkleLink) {
                return Collections.singletonList(new Link("", 0L, ((CborObject.CborMerkleLink)base).target));
            }
            if (base instanceof CborObject.CborMap) {
                return ((CborObject.CborMap)base).values.values().stream().flatMap(cbor -> CborIpldNode.getLinks(cbor).stream()).collect(Collectors.toList());
            }
            if (base instanceof CborObject.CborList) {
                return ((CborObject.CborList)base).value.stream().flatMap(cbor -> CborIpldNode.getLinks(cbor).stream()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }
}

