/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.cid;

import io.ipfs.multibase.Multibase;
import io.ipfs.multihash.Multihash;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class Cid
extends Multihash {
    public final long version;
    public final Codec codec;
    private static final int MAX_VARINT_LEN64 = 10;

    public Cid(long version, Codec codec, Multihash hash) {
        super(hash);
        this.version = version;
        this.codec = codec;
    }

    public Cid(long version, Codec codec, Multihash.Type type, byte[] hash) {
        super(type, hash);
        this.version = version;
        this.codec = codec;
    }

    public Cid(Multihash h) {
        this(0L, Codec.DagProtobuf, h);
    }

    private byte[] toBytesV0() {
        return super.toBytes();
    }

    private byte[] toBytesV1() {
        byte[] hashBytes = super.toBytes();
        byte[] res = new byte[20 + hashBytes.length];
        int index = Cid.putUvarint(res, 0, this.version);
        index = Cid.putUvarint(res, index, this.codec.type);
        System.arraycopy(hashBytes, 0, res, index, hashBytes.length);
        return Arrays.copyOfRange(res, 0, index + hashBytes.length);
    }

    public byte[] toBytes() {
        if (this.version == 0L) {
            return this.toBytesV0();
        }
        if (this.version == 1L) {
            return this.toBytesV1();
        }
        throw new IllegalStateException("Unknown cid version: " + this.version);
    }

    public String toString() {
        if (this.version == 0L) {
            return super.toString();
        }
        if (this.version == 1L) {
            return Multibase.encode((Multibase.Base)Multibase.Base.Base58BTC, (byte[])this.toBytesV1());
        }
        throw new IllegalStateException("Unknown Cid version: " + this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Multihash)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof Cid) {
            Cid cid = (Cid)((Object)o);
            if (this.version != cid.version) {
                return false;
            }
            return this.codec == cid.codec;
        }
        return this.version == 0L && super.equals(o);
    }

    public int hashCode() {
        int result = super.hashCode();
        if (this.version == 0L) {
            return result;
        }
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.codec != null ? this.codec.hashCode() : 0);
        return result;
    }

    public static Cid buildCidV0(Multihash h) {
        return new Cid(h);
    }

    public static Cid buildCidV1(Codec c, Multihash.Type type, byte[] hash) {
        return new Cid(1L, c, type, hash);
    }

    public static Cid decode(String v) {
        if (v.length() < 2) {
            throw new IllegalStateException("Cid too short!");
        }
        if (v.length() == 46 && v.startsWith("Qm")) {
            return Cid.buildCidV0(Multihash.fromBase58((String)v));
        }
        byte[] data = Multibase.decode((String)v);
        return Cid.cast(data);
    }

    public static Cid cast(byte[] data) {
        if (data.length == 34 && data[0] == 18 && data[1] == 32) {
            return Cid.buildCidV0(new Multihash(data));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            long version = Cid.readVarint(in);
            if (version != 0L && version != 1L) {
                throw new CidEncodingException("Invalid Cid version number: " + version);
            }
            long codec = Cid.readVarint(in);
            if (version != 0L && version != 1L) {
                throw new CidEncodingException("Invalid Cid version number: " + version);
            }
            Multihash hash = Multihash.deserialize((DataInput)new DataInputStream(in));
            return new Cid(version, Codec.lookup(codec), hash);
        }
        catch (IOException e) {
            throw new CidEncodingException("Invalid cid bytes: " + Stream.of(data).map(b -> String.format("%02x", b)).reduce("", (a, b) -> a + b));
        }
    }

    private static long readVarint(InputStream in) throws IOException {
        long x = 0L;
        int s = 0;
        for (int i = 0; i < 10; ++i) {
            int b = in.read();
            if (b == -1) {
                throw new EOFException();
            }
            if (b < 128) {
                if (i > 9 || i == 9 && b > 1) {
                    throw new IllegalStateException("Overflow reading varint" + -(i + 1));
                }
                return x | (long)b << s;
            }
            x |= ((long)b & 0x7FL) << s;
            s += 7;
        }
        throw new IllegalStateException("Varint too long!");
    }

    private static int putUvarint(byte[] buf, int index, long x) {
        while (x >= 128L) {
            buf[index] = (byte)(x | 0x80L);
            x >>= 7;
            ++index;
        }
        buf[index] = (byte)x;
        return index + 1;
    }

    public static enum Codec {
        Raw(85L),
        DagProtobuf(112L),
        DagCbor(113L),
        EthereumBlock(144L),
        EthereumTx(145L),
        BitcoinBlock(176L),
        BitcoinTx(177L),
        ZcashBlock(192L),
        ZcashTx(193L);

        public long type;
        private static Map<Long, Codec> lookup;

        private Codec(long type) {
            this.type = type;
        }

        public static Codec lookup(long c) {
            if (!lookup.containsKey(c)) {
                throw new IllegalStateException("Unknown Codec type: " + c);
            }
            return lookup.get(c);
        }

        static {
            lookup = new TreeMap<Long, Codec>();
            for (Codec c : Codec.values()) {
                lookup.put(c.type, c);
            }
        }
    }

    public static final class CidEncodingException
    extends RuntimeException {
        public CidEncodingException(String message) {
            super(message);
        }
    }
}

