/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeAdapter;
import org.apache.camel.component.kafka.consumer.support.KafkaResumable;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignmentListener
implements ConsumerRebalanceListener {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionAssignmentListener.class);
    private final String threadId;
    private final KafkaConfiguration configuration;
    private final KafkaConsumerResumeAdapter resumeStrategy;
    private final CommitManager commitManager;

    public PartitionAssignmentListener(String threadId, KafkaConfiguration configuration, CommitManager commitManager, KafkaConsumerResumeAdapter resumeStrategy) {
        this.threadId = threadId;
        this.configuration = configuration;
        this.commitManager = commitManager;
        this.resumeStrategy = resumeStrategy;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            LOG.debug("onPartitionsRevoked: {} from {}", (Object)this.threadId, (Object)partition.topic());
            if (this.configuration.getAutoCommitEnable()) continue;
            this.commitManager.commit(partition);
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        if (LOG.isDebugEnabled()) {
            partitions.forEach(p -> LOG.debug("onPartitionsAssigned: {} from {}", (Object)this.threadId, (Object)p.topic()));
        }
        List<KafkaResumable> resumables = partitions.stream().map(p -> new KafkaResumable(String.valueOf(p.partition()), p.topic())).collect(Collectors.toList());
        resumables.forEach(this::doResume);
    }

    private void doResume(KafkaResumable r) {
        this.resumeStrategy.setKafkaResumable(r);
        this.resumeStrategy.resume();
    }
}

