/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote.protostream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.util.ClassLoadingAwareObjectInputStream;

final class DefaultExchangeHolderUtils {
    private DefaultExchangeHolderUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] serialize(DefaultExchangeHolder holder) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(holder);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static DefaultExchangeHolder deserialize(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            DefaultExchangeHolder defaultExchangeHolder;
            try (ClassLoadingAwareObjectInputStream ois = new ClassLoadingAwareObjectInputStream((InputStream)bais);){
                defaultExchangeHolder = (DefaultExchangeHolder)ois.readObject();
            }
            return defaultExchangeHolder;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

