/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class InfinispanRemoteEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":cacheName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "infinispan".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "cacheName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(27);
        props.add("bridgeErrorHandler");
        props.add("cacheContainer");
        props.add("cacheContainerConfiguration");
        props.add("cacheName");
        props.add("configurationProperties");
        props.add("configurationUri");
        props.add("customListener");
        props.add("defaultValue");
        props.add("eventTypes");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("flags");
        props.add("hosts");
        props.add("key");
        props.add("lazyStartProducer");
        props.add("oldValue");
        props.add("operation");
        props.add("password");
        props.add("queryBuilder");
        props.add("remappingFunction");
        props.add("resultHeader");
        props.add("saslMechanism");
        props.add("secure");
        props.add("securityRealm");
        props.add("securityServerName");
        props.add("username");
        props.add("value");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("password");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

