/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class MemoryStorageConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryStorageConfiguration>,
ConfigurationBuilderInfo {
    private AttributeSet attributes;
    private StorageType storageType = StorageType.OBJECT;

    MemoryStorageConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = MemoryStorageConfiguration.attributeDefinitionSet();
    }

    public MemoryStorageConfigurationBuilder storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public MemoryStorageConfigurationBuilder size(long size) {
        this.attributes.attribute(MemoryStorageConfiguration.SIZE).set((Object)size);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return MemoryConfiguration.ELEMENT_DEFINITION;
    }

    public long size() {
        return (Long)this.attributes.attribute(MemoryStorageConfiguration.SIZE).get();
    }

    public MemoryStorageConfigurationBuilder evictionType(EvictionType type) {
        this.attributes.attribute(MemoryStorageConfiguration.EVICTION_TYPE).set((Object)type);
        return this;
    }

    public EvictionType evictionType() {
        return (EvictionType)((Object)this.attributes.attribute(MemoryStorageConfiguration.EVICTION_TYPE).get());
    }

    public MemoryStorageConfigurationBuilder evictionStrategy(EvictionStrategy strategy) {
        this.attributes.attribute(MemoryStorageConfiguration.EVICTION_STRATEGY).set((Object)strategy);
        return this;
    }

    public EvictionStrategy evictionStrategy() {
        return (EvictionStrategy)((Object)this.attributes.attribute(MemoryStorageConfiguration.EVICTION_STRATEGY).get());
    }

    @Deprecated
    public MemoryStorageConfigurationBuilder addressCount(int addressCount) {
        this.attributes.attribute(MemoryStorageConfiguration.ADDRESS_COUNT).set((Object)addressCount);
        return this;
    }

    @Deprecated
    public int addressCount() {
        return (Integer)this.attributes.attribute(MemoryStorageConfiguration.ADDRESS_COUNT).get();
    }

    public void validate() {
        if (this.storageType != StorageType.OBJECT && this.getBuilder().clustering().hash().groups().isEnabled()) {
            throw Log.CONFIG.groupingOnlyCompatibleWithObjectStorage(this.storageType);
        }
        long size = (Long)this.attributes.attribute(MemoryStorageConfiguration.SIZE).get();
        EvictionType evictionType = (EvictionType)((Object)this.attributes.attribute(MemoryStorageConfiguration.EVICTION_TYPE).get());
        if (evictionType == EvictionType.MEMORY && this.storageType == StorageType.OBJECT) {
            throw Log.CONFIG.offHeapMemoryEvictionNotSupportedWithObject();
        }
        EvictionStrategy strategy = (EvictionStrategy)((Object)this.attributes.attribute(MemoryStorageConfiguration.EVICTION_STRATEGY).get());
        if (!strategy.isEnabled()) {
            if (size > 0L) {
                EvictionStrategy newStrategy = EvictionStrategy.REMOVE;
                this.evictionStrategy(newStrategy);
                Log.CONFIG.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overridden to %s", size, (Object)newStrategy);
            } else if (this.getBuilder().persistence().passivation() && strategy != EvictionStrategy.MANUAL && !this.getBuilder().template()) {
                Log.CONFIG.passivationWithoutEviction();
            }
        } else {
            TransactionConfigurationBuilder transactionConfiguration;
            TransactionMode transactionMode;
            if (size <= 0L) {
                throw Log.CONFIG.invalidEvictionSize();
            }
            if (strategy.isExceptionBased() && ((transactionMode = (transactionConfiguration = this.getBuilder().transaction()).transactionMode()) == null || !transactionMode.isTransactional() || transactionConfiguration.useSynchronization() || transactionConfiguration.use1PcForAutoCommitTransactions())) {
                throw Log.CONFIG.exceptionBasedEvictionOnlySupportedInTransactionalCaches();
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public MemoryStorageConfiguration create() {
        return new MemoryStorageConfiguration(this.attributes.protect(), this.storageType);
    }

    public MemoryStorageConfigurationBuilder read(MemoryStorageConfiguration template) {
        this.attributes.read(template.attributes());
        this.storageType = template.storageType();
        return this;
    }

    public String toString() {
        return "MemoryStorageConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

