/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;

public class PutKeyValueCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 8;
    private Object value;
    private boolean putIfAbsent;
    private boolean successful = true;
    private Metadata metadata;
    private ValueMatcher valueMatcher;

    public PutKeyValueCommand() {
    }

    public PutKeyValueCommand(Object key, Object value, boolean putIfAbsent, Metadata metadata, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(key, segment, flagsBitSet, commandInvocationId);
        this.value = value;
        this.putIfAbsent = putIfAbsent;
        this.valueMatcher = putIfAbsent ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
        this.metadata = metadata;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        if (this.isConditional() || !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES)) {
            return VisitableCommand.LoadType.PRIMARY;
        }
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public byte getCommandId() {
        return 8;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        output.writeObject(this.metadata);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.putIfAbsent);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.metadata = (Metadata)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.setFlagsBitSet(input.readLong());
        this.putIfAbsent = input.readBoolean();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public void setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutKeyValueCommand that = (PutKeyValueCommand)o;
        if (this.putIfAbsent != that.putIfAbsent) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.putIfAbsent ? 1 : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PutKeyValueCommand{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", putIfAbsent=" + this.putIfAbsent + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", metadata=" + this.metadata + ", successful=" + this.successful + ", topologyId=" + this.getTopologyId() + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.putIfAbsent;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.isConditional() || super.isReturnValueExpected();
    }
}

