/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;

public class JsonClientQueryResponse
implements BaseQueryResponse {
    private static final String JSON_TOTAL_RESULTS = "total_results";
    private static final String JSON_HITS = "hits";
    private static final String JSON_HIT = "hit";
    private final JsonObject jsonObject;

    public JsonClientQueryResponse(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public List<?> extractResults(SerializationContext serializationContext) {
        JsonArray hits = this.jsonObject.get(JSON_HITS).getAsJsonArray();
        return StreamSupport.stream(hits.spliterator(), false).map(hit -> hit.getAsJsonObject().get(JSON_HIT).toString()).collect(Collectors.toList());
    }

    @Override
    public long getTotalResults() {
        return this.jsonObject.get(JSON_TOTAL_RESULTS).getAsInt();
    }
}

