/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanEventProcessor;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.support.DefaultConsumer;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;

public abstract class InfinispanConsumer<ContainerType extends BasicCacheContainer, ManagerType extends InfinispanManager<ContainerType>, ConfigurationType extends InfinispanConfiguration>
extends DefaultConsumer
implements InfinispanEventProcessor {
    protected final ConfigurationType configuration;
    protected final ManagerType manager;
    protected final String cacheName;

    protected InfinispanConsumer(InfinispanEndpoint endpoint, Processor processor, String cacheName, ManagerType manager, ConfigurationType configuration) {
        super((Endpoint)endpoint, processor);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = manager;
    }

    @Override
    public void processEvent(String eventType, String cacheName, Object key, Object eventData, Consumer<Exchange> consumer) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getMessage().setHeader("CamelInfinispanEventType", (Object)eventType);
        exchange.getMessage().setHeader("CamelInfinispanCacheName", (Object)cacheName);
        if (key != null) {
            exchange.getMessage().setHeader("CamelInfinispanKey", key);
        }
        if (eventData != null) {
            exchange.getMessage().setHeader("CamelInfinispanEventData", eventData);
        }
        if (consumer != null) {
            consumer.accept(exchange);
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }

    public <K, V> BasicCache<K, V> getCache() {
        return this.manager.getCache(this.cacheName);
    }

    public <K, V, C extends BasicCache<K, V>> C getCache(Class<C> type) {
        return (C)((BasicCache)type.cast(this.getCache()));
    }

    public ConfigurationType getConfiguration() {
        return this.configuration;
    }
}

