/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.annotations.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.builtin.impl.TruncatingCalendarBridge;
import org.hibernate.search.bridge.builtin.impl.TruncatingDateBridge;
import org.hibernate.search.bridge.builtin.impl.Truncation;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MappingAnnotatedProperty;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFullTextFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingGenericFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingKeywordFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStandardFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.logging.impl.Log;

public class FieldAnnotationProcessor
implements PropertyMappingAnnotationProcessor<Field> {
    private static final String LEGACY_DEFAULT_NULL_TOKEN = "__DEFAULT_NULL_TOKEN__";
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public void process(PropertyMappingStep mapping, Field annotation, PropertyMappingAnnotationProcessorContext context) {
        MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
        Class propertyType = (Class)annotatedProperty.javaClass(ContainerExtractorPath.defaultExtractors()).get();
        Object optionsStep = String.class.equals((Object)propertyType) || Enum.class.isAssignableFrom(propertyType) || Character.class.equals((Object)propertyType) ? (Analyze.YES.equals((Object)annotation.analyze()) ? this.mapAnalyzed(mapping, annotation, context) : this.mapKeyword(mapping, annotation, context, null)) : this.mapGeneric(mapping, annotation, context);
        optionsStep.searchable(Index.YES.equals((Object)annotation.index()) ? Searchable.YES : Searchable.NO).projectable(Store.YES.equals((Object)annotation.store()) ? Projectable.YES : Projectable.NO);
    }

    private PropertyMappingGenericFieldOptionsStep mapGeneric(PropertyMappingStep mapping, Field annotation, PropertyMappingAnnotationProcessorContext context) {
        BeanReference<? extends ValueBridge<?, ?>> valueBridge;
        String name = this.name(annotation, context);
        PropertyMappingGenericFieldOptionsStep genericOptionsStep = (PropertyMappingGenericFieldOptionsStep)mapping.genericField(name).sortable(this.sortable(name, context) ? Sortable.YES : Sortable.NO);
        String indexNullAs = this.indexNullAs(annotation, context);
        if (indexNullAs != null) {
            genericOptionsStep = (PropertyMappingGenericFieldOptionsStep)genericOptionsStep.indexNullAs(indexNullAs);
        }
        if ((valueBridge = this.valueBridge(context)) != null) {
            genericOptionsStep = (PropertyMappingGenericFieldOptionsStep)genericOptionsStep.valueBridge(valueBridge);
        }
        List<String> facetNames = this.facetNames(name, context);
        for (String facetName : facetNames) {
            if (facetName.isEmpty() || facetName.equals(name)) {
                genericOptionsStep = (PropertyMappingGenericFieldOptionsStep)genericOptionsStep.aggregable(Aggregable.YES);
                continue;
            }
            PropertyMappingGenericFieldOptionsStep facetOptionsStep = (PropertyMappingGenericFieldOptionsStep)((PropertyMappingGenericFieldOptionsStep)mapping.genericField(facetName).aggregable(Aggregable.YES)).searchable(Searchable.NO);
            if (valueBridge != null) {
                facetOptionsStep = (PropertyMappingGenericFieldOptionsStep)facetOptionsStep.valueBridge(valueBridge);
            }
            if (indexNullAs == null) continue;
            facetOptionsStep = (PropertyMappingGenericFieldOptionsStep)facetOptionsStep.indexNullAs(indexNullAs);
        }
        return genericOptionsStep;
    }

    private PropertyMappingStandardFieldOptionsStep<?> mapAnalyzed(PropertyMappingStep mapping, Field annotation, PropertyMappingAnnotationProcessorContext context) {
        String normalizer;
        String name = this.name(annotation, context);
        String analyzer = annotation.analyzer().definition();
        if (analyzer.isEmpty()) {
            analyzer = null;
        }
        if ((normalizer = annotation.normalizer().definition()).isEmpty()) {
            normalizer = null;
        }
        if (analyzer != null && normalizer != null) {
            throw log.cannotReferenceAnalyzerAndNormalizer(name);
        }
        if (normalizer != null) {
            return this.mapKeyword(mapping, annotation, context, normalizer);
        }
        String analyzerOrDefault = this.analyzerOrDefault(context, analyzer);
        return this.mapFullText(mapping, annotation, context, analyzerOrDefault);
    }

    private PropertyMappingStandardFieldOptionsStep<?> mapFullText(PropertyMappingStep mapping, Field annotation, PropertyMappingAnnotationProcessorContext context, String analyzerOrDefault) {
        String name = this.name(annotation, context);
        PropertyMappingFullTextFieldOptionsStep fullTextOptionsStep = mapping.fullTextField(name).analyzer(analyzerOrDefault).norms(this.norms(annotation)).termVector(this.termVector(annotation));
        if (this.sortable(name, context)) {
            throw log.cannotUseAnalyzerOnSortableField(analyzerOrDefault);
        }
        if (!this.facetNames(name, context).isEmpty()) {
            throw log.cannotUseAnalyzerOnFacetField(analyzerOrDefault);
        }
        String indexNullAs = this.indexNullAs(annotation, context);
        if (indexNullAs != null) {
            throw log.cannotUseIndexNullAsAndAnalyzer(analyzerOrDefault, indexNullAs);
        }
        return fullTextOptionsStep;
    }

    private PropertyMappingKeywordFieldOptionsStep mapKeyword(PropertyMappingStep mapping, Field annotation, PropertyMappingAnnotationProcessorContext context, String normalizer) {
        String indexNullAs;
        String name = this.name(annotation, context);
        PropertyMappingKeywordFieldOptionsStep keywordOptionsStep = (PropertyMappingKeywordFieldOptionsStep)mapping.keywordField(name).norms(this.norms(annotation)).sortable(this.sortable(name, context) ? Sortable.YES : Sortable.NO);
        if (normalizer != null) {
            keywordOptionsStep = keywordOptionsStep.normalizer(normalizer);
        }
        if ((indexNullAs = this.indexNullAs(annotation, context)) != null) {
            keywordOptionsStep = (PropertyMappingKeywordFieldOptionsStep)keywordOptionsStep.indexNullAs(indexNullAs);
        }
        List<String> facetNames = this.facetNames(name, context);
        for (String facetName : facetNames) {
            if (facetName.isEmpty() || facetName.equals(name)) {
                keywordOptionsStep = (PropertyMappingKeywordFieldOptionsStep)keywordOptionsStep.aggregable(Aggregable.YES);
                continue;
            }
            PropertyMappingKeywordFieldOptionsStep facetOptionsStep = (PropertyMappingKeywordFieldOptionsStep)((PropertyMappingKeywordFieldOptionsStep)mapping.keywordField(facetName).aggregable(Aggregable.YES)).searchable(Searchable.NO);
            if (normalizer != null) {
                facetOptionsStep = facetOptionsStep.normalizer(normalizer);
            }
            if (indexNullAs == null) continue;
            facetOptionsStep = (PropertyMappingKeywordFieldOptionsStep)facetOptionsStep.indexNullAs(indexNullAs);
        }
        return keywordOptionsStep;
    }

    private String name(Field annotation, PropertyMappingAnnotationProcessorContext context) {
        MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
        return annotation.name().isEmpty() ? annotatedProperty.name() : annotation.name();
    }

    private String analyzerOrDefault(PropertyMappingAnnotationProcessorContext context, String fieldAnnotationAnalyzer) {
        if (fieldAnnotationAnalyzer != null) {
            return fieldAnnotationAnalyzer;
        }
        MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
        Optional<String> propertyLevelAnalyzer = annotatedProperty.allAnnotations().filter(a -> Analyzer.class.equals(a.annotationType())).map(a -> ((Analyzer)a).definition()).filter(a -> !a.isEmpty()).findAny();
        return propertyLevelAnalyzer.orElse("default");
    }

    private String indexNullAs(Field annotation, PropertyMappingAnnotationProcessorContext context) {
        String indexNullAs = annotation.indexNullAs();
        if (LEGACY_DEFAULT_NULL_TOKEN.equals(indexNullAs)) {
            throw log.defaultNullTokenNotSupported(context.annotatedElement().javaClass());
        }
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            return null;
        }
        return indexNullAs;
    }

    private boolean sortable(String fieldName, PropertyMappingAnnotationProcessorContext context) {
        MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
        return annotatedProperty.allAnnotations().filter(a -> SortableField.class.equals(a.annotationType())).map(a -> ((SortableField)a).forField()).anyMatch(forField -> forField.equals(fieldName) || forField.isEmpty() && fieldName.equals(annotatedProperty.name()));
    }

    private List<String> facetNames(String fieldName, PropertyMappingAnnotationProcessorContext context) {
        MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
        return annotatedProperty.allAnnotations().filter(a -> Facet.class.equals(a.annotationType())).map(a -> (Facet)a).filter(a -> a.forField().equals(fieldName) || a.forField().isEmpty() && fieldName.equals(annotatedProperty.name())).map(Facet::name).collect(Collectors.toList());
    }

    private org.hibernate.search.engine.backend.types.Norms norms(Field annotation) {
        Norms value = annotation.norms();
        switch (value) {
            case YES: {
                return org.hibernate.search.engine.backend.types.Norms.YES;
            }
            case NO: {
                return org.hibernate.search.engine.backend.types.Norms.NO;
            }
        }
        throw new AssertionFailure("Unknown value: " + (Object)((Object)value));
    }

    private org.hibernate.search.engine.backend.types.TermVector termVector(Field annotation) {
        TermVector value = annotation.termVector();
        switch (value) {
            case YES: {
                return org.hibernate.search.engine.backend.types.TermVector.YES;
            }
            case NO: {
                return org.hibernate.search.engine.backend.types.TermVector.NO;
            }
            case WITH_OFFSETS: {
                return org.hibernate.search.engine.backend.types.TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return org.hibernate.search.engine.backend.types.TermVector.WITH_POSITIONS;
            }
            case WITH_POSITION_OFFSETS: {
                return org.hibernate.search.engine.backend.types.TermVector.WITH_POSITIONS_OFFSETS;
            }
        }
        throw new AssertionFailure("Unknown value: " + (Object)((Object)annotation.termVector()));
    }

    private BeanReference<? extends ValueBridge<?, ?>> valueBridge(PropertyMappingAnnotationProcessorContext context) {
        MappingAnnotatedProperty annotatedProperty = context.annotatedElement();
        return annotatedProperty.allAnnotations().map(a -> this.valueBridge(annotatedProperty, (Annotation)a)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private BeanReference<? extends ValueBridge<?, ?>> valueBridge(MappingAnnotatedProperty annotatedProperty, Annotation annotation) {
        if (Date.class.isAssignableFrom(annotatedProperty.javaClass()) && annotation.annotationType().equals(DateBridge.class)) {
            DateBridge castedAnnotation = (DateBridge)annotation;
            Truncation truncation = Truncation.at(castedAnnotation.resolution());
            return BeanReference.ofInstance((Object)new TruncatingDateBridge(truncation));
        }
        if (Calendar.class.isAssignableFrom(annotatedProperty.javaClass()) && annotation.annotationType().equals(CalendarBridge.class)) {
            CalendarBridge castedAnnotation = (CalendarBridge)annotation;
            Truncation truncation = Truncation.at(castedAnnotation.resolution());
            return BeanReference.ofInstance((Object)new TruncatingCalendarBridge(truncation));
        }
        return null;
    }
}

