/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexIndexingPlanExecution;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;

public class LuceneIndexIndexingPlan<R>
implements IndexIndexingPlan<R> {
    private final LuceneWorkFactory factory;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;
    private final EntityReferenceFactory<R> entityReferenceFactory;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final Map<LuceneSerialWorkOrchestrator, List<SingleDocumentIndexingWork>> worksByOrchestrator = new HashMap<LuceneSerialWorkOrchestrator, List<SingleDocumentIndexingWork>>();

    public LuceneIndexIndexingPlan(LuceneWorkFactory factory, WorkExecutionIndexManagerContext indexManagerContext, LuceneIndexEntryFactory indexEntryFactory, BackendSessionContext sessionContext, EntityReferenceFactory<R> entityReferenceFactory, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.factory = factory;
        this.indexEntryFactory = indexEntryFactory;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.tenantIdentifier();
        this.entityReferenceFactory = entityReferenceFactory;
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        String id = referenceProvider.identifier();
        String routingKey = referenceProvider.routingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, routingKey, documentContributor);
        this.collect(id, routingKey, this.factory.add(this.tenantId, this.indexManagerContext.mappedTypeName(), referenceProvider.entityIdentifier(), id, indexEntry));
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        String id = referenceProvider.identifier();
        String routingKey = referenceProvider.routingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, routingKey, documentContributor);
        this.collect(id, routingKey, this.factory.update(this.tenantId, this.indexManagerContext.mappedTypeName(), referenceProvider.entityIdentifier(), id, indexEntry));
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String id = referenceProvider.identifier();
        String routingKey = referenceProvider.routingKey();
        this.collect(id, routingKey, this.factory.delete(this.tenantId, this.indexManagerContext.mappedTypeName(), referenceProvider.entityIdentifier(), id));
    }

    public void process() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<IndexIndexingPlanExecutionReport<R>> executeAndReport() {
        try {
            ArrayList<CompletableFuture<IndexIndexingPlanExecutionReport<R>>> shardReportFutures = new ArrayList<CompletableFuture<IndexIndexingPlanExecutionReport<R>>>();
            for (Map.Entry<LuceneSerialWorkOrchestrator, List<SingleDocumentIndexingWork>> entry : this.worksByOrchestrator.entrySet()) {
                LuceneSerialWorkOrchestrator orchestrator = entry.getKey();
                List<SingleDocumentIndexingWork> works = entry.getValue();
                LuceneIndexIndexingPlanExecution<R> execution = new LuceneIndexIndexingPlanExecution<R>(orchestrator, this.entityReferenceFactory, this.commitStrategy, this.refreshStrategy, works);
                shardReportFutures.add(execution.execute());
            }
            CompletableFuture completableFuture = IndexIndexingPlanExecutionReport.allOf(shardReportFutures);
            return completableFuture;
        }
        finally {
            this.worksByOrchestrator.clear();
        }
    }

    public void discard() {
        this.worksByOrchestrator.clear();
    }

    private void collect(String documentId, String routingKey, SingleDocumentIndexingWork work) {
        LuceneSerialWorkOrchestrator orchestrator = this.indexManagerContext.indexingOrchestrator(documentId, routingKey);
        List<SingleDocumentIndexingWork> works = this.worksByOrchestrator.get(orchestrator);
        if (works == null) {
            works = new ArrayList<SingleDocumentIndexingWork>();
            this.worksByOrchestrator.put(orchestrator, works);
        }
        works.add(work);
    }
}

