/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneCodecAwareSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneNumericMatchPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneNumericMatchPredicate(Builder builder) {
        super(builder);
    }

    private static class Builder<F, E extends Number>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements MatchPredicateBuilder {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private E value;

        private Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.codec = codec;
        }

        public void value(Object value, ValueConvert convert) {
            this.value = (Number)this.convertAndEncode(this.codec, value, convert);
        }

        public void fuzzy(int maxEditDistance, int exactPrefixLength) {
            throw log.fullTextFeaturesNotSupportedByFieldType(this.field.eventContext());
        }

        public void analyzer(String analyzerName) {
            throw log.fullTextFeaturesNotSupportedByFieldType(this.field.eventContext());
        }

        public void skipAnalysis() {
            throw log.fullTextFeaturesNotSupportedByFieldType(this.field.eventContext());
        }

        public SearchPredicate build() {
            return new LuceneNumericMatchPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            return this.codec.getDomain().createExactQuery(this.absoluteFieldPath, this.value);
        }
    }

    public static class Factory<F, E extends Number>
    extends AbstractLuceneCodecAwareSearchValueFieldQueryElementFactory<MatchPredicateBuilder, F, AbstractLuceneNumericFieldCodec<F, E>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public Builder<F, E> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new Builder((AbstractLuceneNumericFieldCodec)this.codec, searchContext, field);
        }
    }
}

