/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class LuceneMatchIdPredicate
extends AbstractLuceneSearchPredicate {
    private final List<String> values;

    private LuceneMatchIdPredicate(Builder builder) {
        super(builder);
        this.values = builder.values;
        builder.values = null;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String value : this.values) {
            builder.add((Query)this.termQuery(value), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private TermQuery termQuery(String value) {
        return new TermQuery(new Term(MetadataFields.idFieldName(), value));
    }

    static class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements MatchIdPredicateBuilder {
        private List<String> values = new ArrayList<String>();

        Builder(LuceneSearchContext searchContext) {
            super(searchContext);
        }

        public void value(Object value, ValueConvert valueConvert) {
            ToDocumentIdentifierValueConverter<?> dslToDocumentIdConverter = this.searchContext.indexes().idDslConverter(valueConvert);
            ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext = this.searchContext.toDocumentIdentifierValueConvertContext();
            this.values.add(dslToDocumentIdConverter.convertUnknown(value, toDocumentIdentifierValueConvertContext));
        }

        public SearchPredicate build() {
            return new LuceneMatchIdPredicate(this);
        }
    }
}

