/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.query.impl;

import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;

public class Queries {
    private static final Query MAIN_DOCUMENT_QUERY = new TermQuery(new Term(MetadataFields.typeFieldName(), "main"));
    private static final Query CHILD_DOCUMENT_QUERY = new TermQuery(new Term(MetadataFields.typeFieldName(), "child"));

    private Queries() {
    }

    public static Query mainDocumentQuery() {
        return MAIN_DOCUMENT_QUERY;
    }

    public static Query childDocumentQuery() {
        return CHILD_DOCUMENT_QUERY;
    }

    public static Query nestedDocumentPathQuery(String absoluteFieldPath) {
        return new TermQuery(new Term(MetadataFields.nestedDocumentPathFieldName(), absoluteFieldPath));
    }

    public static Query boolFilter(Query must, Query filter) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(must, BooleanClause.Occur.MUST);
        queryBuilder.add(filter, BooleanClause.Occur.FILTER);
        return queryBuilder.build();
    }

    public static Query boolFilter(Query must, List<Query> filters) {
        if (filters == null || filters.isEmpty()) {
            return must;
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(must, BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            queryBuilder.add(filter, BooleanClause.Occur.FILTER);
        }
        return queryBuilder.build();
    }

    public static Query term(String absoluteFieldPath, String value) {
        return new TermQuery(new Term(absoluteFieldPath, value));
    }

    public static Query anyTerm(String absoluteFieldPath, Set<String> values) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (String routingKey : values) {
            queryBuilder.add((Query)new TermQuery(new Term(absoluteFieldPath, routingKey)), BooleanClause.Occur.SHOULD);
        }
        return queryBuilder.build();
    }

    public static BitSetProducer parentFilter(String parentNestedDocumentPath) {
        Query parentQuery = parentNestedDocumentPath == null ? Queries.mainDocumentQuery() : Queries.nestedDocumentPathQuery(parentNestedDocumentPath);
        return new QueryBitSetProducer(parentQuery);
    }

    public static BooleanQuery findChildQuery(BitSetProducer parentFilter, Set<String> nestedDocumentPaths, Query originalParentQuery, Query nestedFilter) {
        ToChildBlockJoinQuery parentQuery = new ToChildBlockJoinQuery(originalParentQuery, parentFilter);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)parentQuery, BooleanClause.Occur.MUST).add((Query)Queries.createNestedDocumentPathSubQuery(nestedDocumentPaths), BooleanClause.Occur.FILTER).add(Queries.childDocumentQuery(), BooleanClause.Occur.FILTER);
        if (nestedFilter != null) {
            builder.add(nestedFilter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    private static BooleanQuery createNestedDocumentPathSubQuery(Set<String> nestedDocumentPaths) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String nestedDocumentPath : nestedDocumentPaths) {
            builder.add(Queries.nestedDocumentPathQuery(nestedDocumentPath), BooleanClause.Occur.SHOULD);
        }
        builder.setMinimumNumberShouldMatch(1);
        return builder.build();
    }
}

