/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.commands.XSiteStateTransferCancelSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferClearStatusCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferRestartSendingCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStatusRequestCommand;
import org.infinispan.xsite.statetransfer.RemoteSiteStatus;
import org.infinispan.xsite.statetransfer.StateTransferStatus;
import org.infinispan.xsite.statetransfer.StatusResponseCollector;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@Scope(value=Scopes.NAMED_CACHE)
public class XSiteStateTransferManagerImpl
implements XSiteStateTransferManager {
    private static final Log log = LogFactory.getLog(XSiteStateTransferManagerImpl.class);
    private static final BiFunction<Throwable, String, Void> DEBUG_CANCEL_FAIL = (t, site) -> {
        log.debugf((Throwable)t, "Unable to cancel x-site state transfer for site %s", site);
        return null;
    };
    @Inject
    RpcManager rpcManager;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    XSiteStateConsumer consumer;
    @Inject
    XSiteStateProvider provider;
    private final ConcurrentMap<String, RemoteSiteStatus> sites = new ConcurrentHashMap<String, RemoteSiteStatus>();
    private volatile int currentTopologyId = -1;
    private volatile boolean isStateTransferInProgress;

    public XSiteStateTransferManagerImpl(Configuration configuration) {
        for (BackupConfiguration bc : configuration.sites().allBackups()) {
            this.sites.put(bc.site(), RemoteSiteStatus.fromConfiguration(bc));
        }
    }

    @Start
    public void start() {
        this.sites.remove(this.rpcManager.getTransport().localSiteName());
    }

    @Override
    public void notifyStatePushFinished(String siteName, Address node, boolean statusOk) {
        RemoteSiteStatus status = (RemoteSiteStatus)this.sites.get(siteName);
        assert (status != null);
        if (status.confirmStateTransfer(node, statusOk)) {
            this.cancelStateTransferSending(siteName).exceptionally(t -> {
                log.xsiteCancelSendFailed((Throwable)t, siteName);
                return null;
            });
            if (status.isSync()) {
                this.sendStateTransferFinishToRemoteSite(status).exceptionally(t -> {
                    log.xsiteCancelReceiveFailed((Throwable)t, this.getLocalSite(), siteName);
                    return null;
                });
            }
        }
    }

    @Override
    public final void startPushState(String siteName) {
        RemoteSiteStatus status = this.validateSite(siteName);
        if (!status.startStateTransfer(this.rpcManager.getMembers())) {
            throw log.xsiteStateTransferAlreadyInProgress(siteName);
        }
        try {
            if (status.isSync()) {
                XSiteStateTransferStartReceiveCommand remoteSiteCommand = this.commandsFactory.buildXSiteStateTransferStartReceiveCommand();
                this.rpcManager.blocking(this.rpcManager.invokeXSite(status.getBackup(), remoteSiteCommand));
            }
            if (!this.isStateTransferInProgress) {
                XSiteStateTransferStartSendCommand cmd = this.commandsFactory.buildXSiteStateTransferStartSendCommand(siteName, this.currentTopologyId);
                CompletionStage<Void> rsp = this.sendToLocalSite(cmd);
                cmd.setOrigin(this.rpcManager.getAddress());
                cmd.invokeLocal(this.provider);
                this.rpcManager.blocking(rsp);
            } else if (log.isDebugEnabled()) {
                log.debugf("Not starting state transfer to site '%s' while rebalance in progress. Waiting until it is finished!", siteName);
            }
        }
        catch (Throwable throwable) {
            this.handleFailure(status);
            throw throwable;
        }
    }

    @Override
    public List<String> getRunningStateTransfers() {
        return this.sites.values().stream().filter(RemoteSiteStatus::isStateTransferInProgress).map(RemoteSiteStatus::getSiteName).collect(Collectors.toList());
    }

    @Override
    public Map<String, StateTransferStatus> getStatus() {
        return this.sites.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RemoteSiteStatus)e.getValue()).getStatus()));
    }

    @Override
    public void clearStatus() {
        this.sites.values().forEach(RemoteSiteStatus::clearStatus);
    }

    @Override
    public void cancelPushState(String siteName) throws Throwable {
        RemoteSiteStatus status = this.validateSite(siteName);
        status.cancelStateTransfer();
        AggregateCompletionStage<Void> rsp = CompletionStages.aggregateCompletionStage();
        CompletionStage<Void> cancelSending = this.cancelStateTransferSending(siteName);
        cancelSending.exceptionally(t -> {
            log.xsiteCancelSendFailed((Throwable)t, siteName);
            return null;
        });
        rsp.dependsOn(cancelSending);
        if (status.isSync()) {
            CompletionStage<Void> cancelReceiving = this.sendStateTransferFinishToRemoteSite(status);
            cancelReceiving.exceptionally(t -> {
                log.xsiteCancelReceiveFailed((Throwable)t, this.getLocalSite(), siteName);
                return null;
            });
            rsp.dependsOn(cancelReceiving);
        }
        rsp.freeze().toCompletableFuture().join();
    }

    @Override
    public Map<String, StateTransferStatus> getClusterStatus() {
        XSiteStateTransferStatusRequestCommand command = this.commandsFactory.buildXSiteStateTransferStatusRequestCommand();
        StatusResponseCollector collector = new StatusResponseCollector();
        this.getStatus().forEach(collector);
        return this.rpcManager.blocking(this.rpcManager.invokeCommandOnAll(command, collector, this.rpcManager.getSyncRpcOptions()));
    }

    @Override
    public void clearClusterStatus() {
        XSiteStateTransferClearStatusCommand cmd = this.commandsFactory.buildXSiteStateTransferClearStatusCommand();
        CompletionStage<Void> rsp = this.rpcManager.invokeCommandOnAll(cmd, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        cmd.invokeLocal(this);
        this.rpcManager.blocking(rsp);
    }

    @Override
    public String getSendingSiteName() {
        return this.consumer.getSendingSiteName();
    }

    @Override
    public void cancelReceive(String siteName) {
        XSiteStateTransferFinishReceiveCommand cmd = this.commandsFactory.buildXSiteStateTransferFinishReceiveCommand(siteName);
        CompletionStage<Void> rsp = this.sendToLocalSite(cmd);
        cmd.invokeLocal(this.consumer);
        this.rpcManager.blocking(rsp);
    }

    @Override
    public void becomeCoordinator(String siteName) {
        this.startCoordinating(Collections.singleton(siteName), this.rpcManager.getMembers());
        if (this.isStateTransferInProgress) {
            this.doCancelSendingForRestart(siteName);
        } else {
            if (log.isDebugEnabled()) {
                log.debugf("Restarting x-site state transfer for site %s", siteName);
            }
            try {
                this.rpcManager.blocking(this.restartStateTransferSending(siteName));
            }
            catch (Exception e) {
                log.failedToRestartXSiteStateTransfer(siteName, e);
            }
        }
    }

    @Override
    public XSiteStateProvider getStateProvider() {
        return this.provider;
    }

    @Override
    public XSiteStateConsumer getStateConsumer() {
        return this.consumer;
    }

    @Override
    public void onTopologyUpdated(CacheTopology cacheTopology, boolean stateTransferInProgress) {
        int topologyId = cacheTopology.getTopologyId();
        if (log.isDebugEnabled()) {
            log.debugf("Topology change. TopologyId: %s. State transfer in progress? %s", Integer.toString(topologyId), stateTransferInProgress);
        }
        this.currentTopologyId = topologyId;
        this.isStateTransferInProgress = stateTransferInProgress;
        List<Address> newMembers = cacheTopology.getMembers();
        boolean amINewCoordinator = newMembers.get(0).equals(this.rpcManager.getAddress());
        Collection<String> missingCoordinatorSites = this.provider.getSitesMissingCoordinator(new HashSet<Address>(newMembers));
        if (amINewCoordinator) {
            this.startCoordinating(missingCoordinatorSites, newMembers);
        }
        if (stateTransferInProgress) {
            this.sites.values().stream().filter(RemoteSiteStatus::isStateTransferInProgress).map(RemoteSiteStatus::getSiteName).forEach(this::doCancelSendingForRestart);
        } else {
            for (RemoteSiteStatus status : this.sites.values()) {
                if (!status.restartStateTransfer(newMembers)) continue;
                String siteName = status.getSiteName();
                if (log.isDebugEnabled()) {
                    log.debugf("Topology change detected! Restarting x-site state transfer for site %s", siteName);
                }
                try {
                    this.restartStateTransferSending(siteName);
                }
                catch (Exception e) {
                    log.failedToRestartXSiteStateTransfer(siteName, e);
                }
            }
        }
    }

    private String getLocalSite() {
        return this.rpcManager.getTransport().localSiteName();
    }

    private void doCancelSendingForRestart(String siteName) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debugf("Canceling x-site state transfer for site %s", siteName);
                }
                CompletionStage<Void> rsp = this.cancelStateTransferSending(siteName);
                if (log.isDebugEnabled()) {
                    rsp.exceptionally(t -> DEBUG_CANCEL_FAIL.apply((Throwable)t, siteName));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                DEBUG_CANCEL_FAIL.apply(e, siteName);
            }
        }
    }

    private RemoteSiteStatus validateSite(String siteName) throws NullPointerException, IllegalArgumentException {
        RemoteSiteStatus status = (RemoteSiteStatus)this.sites.get(Objects.requireNonNull(siteName, "Site name cannot be null."));
        if (status == null) {
            throw log.siteNotFound(siteName);
        }
        return status;
    }

    private CompletionStage<Void> cancelStateTransferSending(String siteName) {
        XSiteStateTransferCancelSendCommand cmd = this.commandsFactory.buildXSiteStateTransferCancelSendCommand(siteName);
        CompletionStage<Void> rsp = this.sendToLocalSite(cmd);
        cmd.invokeLocal(this.provider);
        return rsp;
    }

    private CompletionStage<Void> restartStateTransferSending(String siteName) {
        int topologyId = this.currentTopologyId;
        XSiteStateTransferRestartSendingCommand cmd = this.commandsFactory.buildXSiteStateTransferRestartSendingCommand(siteName, topologyId);
        CompletionStage<Void> rsp = this.sendToLocalSite(cmd);
        cmd.setOrigin(this.rpcManager.getAddress());
        cmd.invokeLocal(this.provider);
        return rsp;
    }

    private void startCoordinating(Collection<String> sitesName, Collection<Address> members) {
        if (log.isDebugEnabled()) {
            log.debugf("Becoming the x-site state transfer coordinator for %s", sitesName);
        }
        for (String siteName : sitesName) {
            RemoteSiteStatus status = (RemoteSiteStatus)this.sites.get(siteName);
            assert (status != null);
            status.startStateTransfer(members);
        }
    }

    private void handleFailure(RemoteSiteStatus siteStatus) {
        String siteName = siteStatus.getSiteName();
        if (log.isDebugEnabled()) {
            log.debugf("Handle start state transfer failure to %s", siteName);
        }
        siteStatus.failStateTransfer();
        CompletionStage<Void> rsp = this.cancelStateTransferSending(siteName);
        if (log.isDebugEnabled()) {
            rsp.exceptionally(t -> DEBUG_CANCEL_FAIL.apply((Throwable)t, siteName));
        }
        if (!siteStatus.isSync()) {
            return;
        }
        rsp = this.sendStateTransferFinishToRemoteSite(siteStatus);
        if (log.isDebugEnabled()) {
            rsp.exceptionally(t -> {
                log.debugf((Throwable)t, "Exception while cancel receiving in remote site %s", siteName);
                return null;
            });
        }
    }

    private CompletionStage<Void> sendToLocalSite(CacheRpcCommand command) {
        return this.rpcManager.invokeCommandOnAll(command, VoidResponseCollector.ignoreLeavers(), this.fifoSyncRpcOptions());
    }

    private CompletionStage<Void> sendStateTransferFinishToRemoteSite(RemoteSiteStatus status) {
        return this.rpcManager.invokeXSite(status.getBackup(), this.commandsFactory.buildXSiteStateTransferFinishReceiveCommand(null));
    }

    private RpcOptions fifoSyncRpcOptions() {
        RpcOptions sync = this.rpcManager.getSyncRpcOptions();
        return new RpcOptions(DeliverOrder.PER_SENDER, sync.timeout(), sync.timeUnit());
    }
}

