/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutboundTransferTask;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionOriginatorChecker;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class StateProviderImpl
implements StateProvider {
    private static final Log log = LogFactory.getLog(StateProviderImpl.class);
    @ComponentName(value="cacheName")
    @Inject
    protected String cacheName;
    @Inject
    Configuration configuration;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    ClusterCacheNotifier clusterCacheNotifier;
    @Inject
    TransactionTable transactionTable;
    @Inject
    protected InternalDataContainer<Object, Object> dataContainer;
    @Inject
    protected PersistenceManager persistenceManager;
    @Inject
    protected StateTransferLock stateTransferLock;
    @Inject
    protected InternalEntryFactory entryFactory;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    protected TransactionOriginatorChecker transactionOriginatorChecker;
    @ComponentName(value="org.infinispan.executors.timeout")
    @Inject
    ScheduledExecutorService timeoutExecutor;
    protected long timeout;
    protected int chunkSize;
    private final Map<Address, List<OutboundTransferTask>> transfersByDestination = new HashMap<Address, List<OutboundTransferTask>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStateTransferInProgress() {
        Map<Address, List<OutboundTransferTask>> map = this.transfersByDestination;
        synchronized (map) {
            return !this.transfersByDestination.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> onTopologyUpdate(CacheTopology cacheTopology, boolean isRebalance) {
        HashSet<Address> members = new HashSet<Address>(cacheTopology.getWriteConsistentHash().getMembers());
        Map<Address, List<OutboundTransferTask>> map = this.transfersByDestination;
        synchronized (map) {
            Iterator<Map.Entry<Address, List<OutboundTransferTask>>> it = this.transfersByDestination.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Address, List<OutboundTransferTask>> destination = it.next();
                Address address = destination.getKey();
                if (members.contains(address)) continue;
                List<OutboundTransferTask> transfers = destination.getValue();
                it.remove();
                for (OutboundTransferTask outboundTransfer : transfers) {
                    outboundTransfer.cancel();
                }
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    @Start(priority=50)
    public void start() {
        this.timeout = this.configuration.clustering().stateTransfer().timeout();
        this.chunkSize = this.configuration.clustering().stateTransfer().chunkSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop(priority=0)
    public void stop() {
        if (log.isTraceEnabled()) {
            log.tracef("Shutting down StateProvider of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        try {
            Map<Address, List<OutboundTransferTask>> map = this.transfersByDestination;
            synchronized (map) {
                Iterator<List<OutboundTransferTask>> it = this.transfersByDestination.values().iterator();
                while (it.hasNext()) {
                    List<OutboundTransferTask> transfers = it.next();
                    it.remove();
                    for (OutboundTransferTask outboundTransfer : transfers) {
                        outboundTransfer.cancel();
                    }
                }
            }
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to stop StateProvider of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
    }

    @Override
    public CompletionStage<List<TransactionInfo>> getTransactionsForSegments(Address destination, int requestTopologyId, IntSet segments) {
        if (log.isTraceEnabled()) {
            log.tracef("Received request for transactions from node %s for cache %s, topology id %d, segments %s", new Object[]{destination, this.cacheName, requestTopologyId, segments});
        }
        return this.getCacheTopology(requestTopologyId, destination, true).thenApply(topology -> {
            ConsistentHash readCh = topology.getReadConsistentHash();
            IntSet ownedSegments = IntSets.from(readCh.getSegmentsForOwner(this.rpcManager.getAddress()));
            if (!ownedSegments.containsAll(segments)) {
                segments.removeAll(ownedSegments);
                throw new IllegalArgumentException("Segments " + segments + " are not owned by " + this.rpcManager.getAddress());
            }
            ArrayList<TransactionInfo> transactions = new ArrayList<TransactionInfo>();
            if (this.configuration.transaction().transactionMode().isTransactional()) {
                this.collectTransactionsToTransfer(destination, (List<TransactionInfo>)transactions, (Collection<? extends CacheTransaction>)this.transactionTable.getRemoteTransactions(), segments, (CacheTopology)topology);
                this.collectTransactionsToTransfer(destination, (List<TransactionInfo>)transactions, (Collection<? extends CacheTransaction>)this.transactionTable.getLocalTransactions(), segments, (CacheTopology)topology);
                if (log.isTraceEnabled()) {
                    log.tracef("Found %d transaction(s) to transfer", transactions.size());
                }
            }
            return transactions;
        });
    }

    @Override
    public Collection<ClusterListenerReplicateCallable<Object, Object>> getClusterListenersToInstall() {
        return this.clusterCacheNotifier.retrieveClusterListenerCallablesToInstall();
    }

    private CompletionStage<CacheTopology> getCacheTopology(int requestTopologyId, Address destination, boolean isReqForTransactions) {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        int currentTopologyId = cacheTopology.getTopologyId();
        if (requestTopologyId < currentTopologyId) {
            if (isReqForTransactions) {
                log.debugf("Transactions were requested by node %s with topology %d, older than the local topology (%d)", destination, requestTopologyId, currentTopologyId);
            } else {
                log.debugf("Segments were requested by node %s with topology %d, older than the local topology (%d)", destination, requestTopologyId, currentTopologyId);
            }
        } else if (requestTopologyId > currentTopologyId) {
            if (log.isTraceEnabled()) {
                log.tracef("%s were requested by node %s with topology %d, greater than the local topology (%d). Waiting for topology %d to be installed locally.", new Object[]{isReqForTransactions ? "Transactions" : "Segments", destination, requestTopologyId, currentTopologyId, requestTopologyId});
            }
            CompletableFuture<Void> topologyFuture = this.stateTransferLock.topologyFuture(requestTopologyId);
            this.timeoutExecutor.schedule(() -> topologyFuture.completeExceptionally((Throwable)((Object)Log.CLUSTER.failedWaitingForTopology(requestTopologyId))), this.timeout, TimeUnit.MILLISECONDS);
            return topologyFuture.thenApply(ignored -> this.distributionManager.getCacheTopology());
        }
        return CompletableFuture.completedFuture(cacheTopology);
    }

    private void collectTransactionsToTransfer(Address destination, List<TransactionInfo> transactionsToTransfer, Collection<? extends CacheTransaction> transactions, IntSet segments, CacheTopology cacheTopology) {
        int topologyId = cacheTopology.getTopologyId();
        HashSet<Address> members = new HashSet<Address>(cacheTopology.getMembers());
        for (CacheTransaction cacheTransaction : transactions) {
            GlobalTransaction gtx = cacheTransaction.getGlobalTransaction();
            if (cacheTransaction.getTopologyId() == topologyId || this.transactionOriginatorChecker.isOriginatorMissing(gtx, members)) {
                if (!log.isTraceEnabled()) continue;
                log.tracef("Skipping transaction %s as it was started in the current topology or by a leaver", cacheTransaction);
                continue;
            }
            HashSet<Object> filteredLockedKeys = new HashSet<Object>();
            Consumer<Object> lockFilter = key -> {
                if (segments.contains(this.keyPartitioner.getSegment(key))) {
                    filteredLockedKeys.add(key);
                }
            };
            cacheTransaction.forEachLock(lockFilter);
            cacheTransaction.forEachBackupLock(lockFilter);
            if (filteredLockedKeys.isEmpty()) {
                if (!log.isTraceEnabled()) continue;
                log.tracef("Skipping transaction %s because the state requestor %s doesn't own any key", cacheTransaction, destination);
                continue;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Sending transaction %s to new owner %s", cacheTransaction, destination);
            }
            List<WriteCommand> txModifications = cacheTransaction.getModifications();
            WriteCommand[] modifications = null;
            if (!txModifications.isEmpty()) {
                modifications = txModifications.toArray(new WriteCommand[0]);
            }
            if (cacheTransaction instanceof LocalTransaction) {
                LocalTransaction localTx = (LocalTransaction)cacheTransaction;
                localTx.locksAcquired(Collections.singleton(destination));
                if (log.isTraceEnabled()) {
                    log.tracef("Adding affected node %s to transferred transaction %s (keys %s)", destination, gtx, filteredLockedKeys);
                }
            }
            transactionsToTransfer.add(new TransactionInfo(gtx, cacheTransaction.getTopologyId(), modifications, filteredLockedKeys));
        }
    }

    @Override
    public void startOutboundTransfer(Address destination, int requestTopologyId, IntSet segments, boolean applyState) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting outbound transfer to node %s for cache %s, topology id %d, segments %s", new Object[]{destination, this.cacheName, requestTopologyId, segments});
        }
        OutboundTransferTask outboundTransfer = new OutboundTransferTask(destination, segments, this.configuration.clustering().hash().numSegments(), this.chunkSize, requestTopologyId, this.keyPartitioner, chunks -> {}, this.rpcManager, this.commandsFactory, this.timeout, this.cacheName, applyState, false);
        this.addTransfer(outboundTransfer);
        outboundTransfer.execute((Flowable<InternalCacheEntry<Object, Object>>)Flowable.concat(this.publishDataContainerEntries(segments), this.publishStoreEntries(segments))).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                this.logError(outboundTransfer, (Throwable)throwable);
            }
            this.onTaskCompletion(outboundTransfer);
        });
    }

    protected Flowable<InternalCacheEntry<Object, Object>> publishDataContainerEntries(IntSet segments) {
        return Flowable.fromIterable(() -> this.dataContainer.iterator(segments)).filter(ice -> !ice.isL1Entry());
    }

    protected Flowable<InternalCacheEntry<Object, Object>> publishStoreEntries(IntSet segments) {
        Publisher loaderPublisher = this.persistenceManager.publishEntries(segments, k -> !this.dataContainer.containsKey(k), true, true, Configurations::isStateTransferStore);
        return Flowable.fromPublisher(loaderPublisher).map(this::defaultMapEntryFromStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTransfer(OutboundTransferTask transferTask) {
        if (log.isTraceEnabled()) {
            log.tracef("Adding outbound transfer to %s for segments %s", transferTask.getDestination(), transferTask.getSegments());
        }
        Map<Address, List<OutboundTransferTask>> map = this.transfersByDestination;
        synchronized (map) {
            List transfers = this.transfersByDestination.computeIfAbsent(transferTask.getDestination(), k -> new ArrayList());
            transfers.add(transferTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelOutboundTransfer(Address destination, int topologyId, IntSet segments) {
        if (log.isTraceEnabled()) {
            log.tracef("Cancelling outbound transfer to node %s for cache %s, topology id %d, segments %s", new Object[]{destination, this.cacheName, topologyId, segments});
        }
        Map<Address, List<OutboundTransferTask>> map = this.transfersByDestination;
        synchronized (map) {
            List<OutboundTransferTask> transferTasks = this.transfersByDestination.get(destination);
            if (transferTasks != null) {
                OutboundTransferTask[] taskListCopy;
                for (OutboundTransferTask transferTask : taskListCopy = transferTasks.toArray(new OutboundTransferTask[0])) {
                    if (transferTask.getTopologyId() != topologyId) continue;
                    transferTask.cancelSegments(segments);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransfer(OutboundTransferTask transferTask) {
        Map<Address, List<OutboundTransferTask>> map = this.transfersByDestination;
        synchronized (map) {
            List<OutboundTransferTask> transferTasks = this.transfersByDestination.get(transferTask.getDestination());
            if (transferTasks != null) {
                transferTasks.remove(transferTask);
                if (transferTasks.isEmpty()) {
                    this.transfersByDestination.remove(transferTask.getDestination());
                }
            }
        }
    }

    protected void onTaskCompletion(OutboundTransferTask transferTask) {
        if (log.isTraceEnabled()) {
            log.tracef("Removing %s outbound transfer of segments to %s for cache %s, segments %s", new Object[]{transferTask.isCancelled() ? "cancelled" : "completed", transferTask.getDestination(), this.cacheName, transferTask.getSegments()});
        }
        this.removeTransfer(transferTask);
    }

    protected void logError(OutboundTransferTask task, Throwable t) {
        if (task.isCancelled()) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignoring error in already cancelled transfer to node %s, segments %s", task.getDestination(), task.getSegments());
            }
        } else {
            log.failedOutBoundTransferExecution(t);
        }
    }

    private InternalCacheEntry<Object, Object> defaultMapEntryFromStore(MarshallableEntry<Object, Object> me) {
        InternalCacheEntry<Object, Object> entry = this.entryFactory.create(me.getKey(), me.getValue(), me.getMetadata());
        entry.setInternalMetadata(me.getInternalMetadata());
        return entry;
    }
}

